@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property tags Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
 */
public data class WorkflowOnExceptionStepTagStepDetailsArgs(
    public val name: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
    public val tags: Output<List<WorkflowOnExceptionStepTagStepDetailsTagArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowOnExceptionStepTagStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepTagStepDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    private var tags: Output<List<WorkflowOnExceptionStepTagStepDetailsTagArgs>>? = null

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("oaarvwuafdsmompn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("ddwisgsnojfpxaeg")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("acmlqnvpdqabfdur")
    public suspend fun tags(`value`: Output<List<WorkflowOnExceptionStepTagStepDetailsTagArgs>>) {
        this.tags = value
    }

    @JvmName("whrirndncpmnawun")
    public suspend fun tags(vararg values: Output<WorkflowOnExceptionStepTagStepDetailsTagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("dgakfjmrwpevcswx")
    public suspend fun tags(values: List<Output<WorkflowOnExceptionStepTagStepDetailsTagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("xmrmpekquqrahidp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("wrevcthfsjvtfbit")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    /**
     * @param value Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("etsphmiwneebfyqg")
    public suspend fun tags(`value`: List<WorkflowOnExceptionStepTagStepDetailsTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("cnwfvhiouhpavptj")
    public suspend fun tags(argument: List<suspend WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("rykbeqnxeorcenkj")
    public suspend fun tags(vararg argument: suspend WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("mtutikqtfnltlwhx")
    public suspend fun tags(argument: suspend WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("nuxdfyehjnjbohpl")
    public suspend fun tags(vararg values: WorkflowOnExceptionStepTagStepDetailsTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowOnExceptionStepTagStepDetailsArgs =
        WorkflowOnExceptionStepTagStepDetailsArgs(
            name = name,
            sourceFileLocation = sourceFileLocation,
            tags = tags,
        )
}
