@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileLocation Specifies the details for the EFS file being copied.
 * @property s3FileLocation Specifies the details for the S3 file being copied.
 */
public data class WorkflowStepCopyStepDetailsDestinationFileLocationArgs(
    public val efsFileLocation: Output<WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>? = null,
    public val s3FileLocation: Output<WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationArgs.builder()
            .efsFileLocation(efsFileLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3FileLocation(
                s3FileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowStepCopyStepDetailsDestinationFileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowStepCopyStepDetailsDestinationFileLocationArgsBuilder internal constructor() {
    private var efsFileLocation:
        Output<WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>? = null

    private var s3FileLocation:
        Output<WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>? = null

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("djxbnsypihfvvjur")
    public suspend fun efsFileLocation(`value`: Output<WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>) {
        this.efsFileLocation = value
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("cxwwsgnwucvmokfv")
    public suspend fun s3FileLocation(`value`: Output<WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>) {
        this.s3FileLocation = value
    }

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("xtdhvsmicfdmurnn")
    public suspend fun efsFileLocation(`value`: WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the EFS file being copied.
     */
    @JvmName("xarwaijvvrbbjsgs")
    public suspend fun efsFileLocation(argument: suspend WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.efsFileLocation = mapped
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("mblmvlbjhucmedur")
    public suspend fun s3FileLocation(`value`: WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3FileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the S3 file being copied.
     */
    @JvmName("jafpffkneyauaufu")
    public suspend fun s3FileLocation(argument: suspend WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3FileLocation = mapped
    }

    internal fun build(): WorkflowStepCopyStepDetailsDestinationFileLocationArgs =
        WorkflowStepCopyStepDetailsDestinationFileLocationArgs(
            efsFileLocation = efsFileLocation,
            s3FileLocation = s3FileLocation,
        )
}
