@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemId The ID of the file system, assigned by Amazon EFS.
 * @property path The pathname for the folder being used by a workflow.
 */
public data class WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs(
    public val fileSystemId: Output<String>? = null,
    public val path: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs.builder()
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The ID of the file system, assigned by Amazon EFS.
     */
    @JvmName("fruupskugmqvrlui")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The pathname for the folder being used by a workflow.
     */
    @JvmName("rsmultmvekbucals")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The ID of the file system, assigned by Amazon EFS.
     */
    @JvmName("jkfglfevpwrmeoag")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The pathname for the folder being used by a workflow.
     */
    @JvmName("wqbtibhoatjxexdw")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs =
        WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs(
            fileSystemId = fileSystemId,
            path = path,
        )
}
