@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Specifies the S3 bucket for the customer input file.
 * @property key The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
 */
public data class WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs(
    public val bucket: Output<String>? = null,
    public val key: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value Specifies the S3 bucket for the customer input file.
     */
    @JvmName("pgqqsqyiosproswd")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */
    @JvmName("vftvxhhixqwgyfyu")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Specifies the S3 bucket for the customer input file.
     */
    @JvmName("qdxpemmvhpananso")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */
    @JvmName("wlvkvxrbohytmayu")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs =
        WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs(
            bucket = bucket,
            key = key,
        )
}
