@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property tags Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
 */
public data class WorkflowStepTagStepDetailsArgs(
    public val name: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
    public val tags: Output<List<WorkflowStepTagStepDetailsTagArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowStepTagStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowStepTagStepDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    private var tags: Output<List<WorkflowStepTagStepDetailsTagArgs>>? = null

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("hicwnjdgkjoutvvr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("gbuebxfkmhexdpde")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("pqvdnxekruavjogv")
    public suspend fun tags(`value`: Output<List<WorkflowStepTagStepDetailsTagArgs>>) {
        this.tags = value
    }

    @JvmName("bayqjbgnqgcmheru")
    public suspend fun tags(vararg values: Output<WorkflowStepTagStepDetailsTagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("qadqifafmfmadixh")
    public suspend fun tags(values: List<Output<WorkflowStepTagStepDetailsTagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("hlnbpuaoxgtsneny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("sevoucriagtqfqdw")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    /**
     * @param value Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("phhwwspjhiufrmem")
    public suspend fun tags(`value`: List<WorkflowStepTagStepDetailsTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("qjwwvstofmwnddhh")
    public suspend fun tags(argument: List<suspend WorkflowStepTagStepDetailsTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowStepTagStepDetailsTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("xniueikidwmopima")
    public suspend fun tags(vararg argument: suspend WorkflowStepTagStepDetailsTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkflowStepTagStepDetailsTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("vplgragghtgixupm")
    public suspend fun tags(argument: suspend WorkflowStepTagStepDetailsTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkflowStepTagStepDetailsTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
     */
    @JvmName("eqjkjsdachxiueco")
    public suspend fun tags(vararg values: WorkflowStepTagStepDetailsTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowStepTagStepDetailsArgs = WorkflowStepTagStepDetailsArgs(
        name = name,
        sourceFileLocation = sourceFileLocation,
        tags = tags,
    )
}
