@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property value The value that corresponds to the key.
 */
public data class WorkflowStepTagStepDetailsTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsTagArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsTagArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowStepTagStepDetailsTagArgs].
 */
@PulumiTagMarker
public class WorkflowStepTagStepDetailsTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vdbeqpuwvohodatr")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value that corresponds to the key.
     */
    @JvmName("jrddpvfnmbalrunx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("qvyqpqduejvimalh")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value that corresponds to the key.
     */
    @JvmName("hyhpqjrktctumnfa")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WorkflowStepTagStepDetailsTagArgs = WorkflowStepTagStepDetailsTagArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
