@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property compression Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
 * @property encryptionAlgorithm The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
 * @property localProfileId The unique identifier for the AS2 local profile.
 * @property mdnResponse Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
 * @property mdnSigningAlgorithm The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
 * @property messageSubject Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
 * @property partnerProfileId The unique identifier for the AS2 partner profile.
 * @property signingAlgorithm The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
 */
public data class ConnectorAs2Config(
    public val compression: String,
    public val encryptionAlgorithm: String,
    public val localProfileId: String,
    public val mdnResponse: String,
    public val mdnSigningAlgorithm: String? = null,
    public val messageSubject: String? = null,
    public val partnerProfileId: String,
    public val signingAlgorithm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ConnectorAs2Config): ConnectorAs2Config = ConnectorAs2Config(
            compression = javaType.compression(),
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            localProfileId = javaType.localProfileId(),
            mdnResponse = javaType.mdnResponse(),
            mdnSigningAlgorithm = javaType.mdnSigningAlgorithm().map({ args0 -> args0 }).orElse(null),
            messageSubject = javaType.messageSubject().map({ args0 -> args0 }).orElse(null),
            partnerProfileId = javaType.partnerProfileId(),
            signingAlgorithm = javaType.signingAlgorithm(),
        )
    }
}
