@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property trustedHostKeys A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
 * @property userSecretId The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
 */
public data class ConnectorSftpConfig(
    public val trustedHostKeys: List<String>? = null,
    public val userSecretId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ConnectorSftpConfig): ConnectorSftpConfig = ConnectorSftpConfig(
            trustedHostKeys = javaType.trustedHostKeys().map({ args0 -> args0 }),
            userSecretId = javaType.userSecretId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
