@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property basicAuthSecretId Basic authentication for AS2 connector API. Returns a null value if not set.
 * @property compression Specifies whether AS2 file is compressed. Will be ZLIB or DISABLED
 * @property encryptionAlgorithm Algorithm used to encrypt file. Will be AES128_CBC or AES192_CBC or AES256_CBC or DES_EDE3_CBC or NONE.
 * @property localProfileId Unique identifier for AS2 local profile.
 * @property mdnResponse Used for outbound requests to tell if response is asynchronous or not. Will be either SYNC or NONE.
 * @property mdnSigningAlgorithm Signing algorithm for MDN response. Will be SHA256 or SHA384 or SHA512 or SHA1 or NONE or DEFAULT.
 * @property messageSubject Subject HTTP header attribute in outbound AS2 messages to the connector.
 * @property partnerProfileId Unique identifier used by connector for partner profile.
 * @property singingAlgorithm
 */
public data class GetConnectorAs2Config(
    public val basicAuthSecretId: String,
    public val compression: String,
    public val encryptionAlgorithm: String,
    public val localProfileId: String,
    public val mdnResponse: String,
    public val mdnSigningAlgorithm: String,
    public val messageSubject: String,
    public val partnerProfileId: String,
    public val singingAlgorithm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.GetConnectorAs2Config): GetConnectorAs2Config = GetConnectorAs2Config(
            basicAuthSecretId = javaType.basicAuthSecretId(),
            compression = javaType.compression(),
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            localProfileId = javaType.localProfileId(),
            mdnResponse = javaType.mdnResponse(),
            mdnSigningAlgorithm = javaType.mdnSigningAlgorithm(),
            messageSubject = javaType.messageSubject(),
            partnerProfileId = javaType.partnerProfileId(),
            singingAlgorithm = javaType.singingAlgorithm(),
        )
    }
}
