@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConnector.
 * @property accessRole ARN of the AWS Identity and Access Management role.
 * @property arn ARN of the Connector.
 * @property as2Configs Structure containing the parameters for an AS2 connector object. Contains the following attributes:
 * @property id
 * @property loggingRole ARN of the IAM role that allows a connector to turn on CLoudwatch logging for Amazon S3 events.
 * @property securityPolicyName Name of security policy.
 * @property serviceManagedEgressIpAddresses List of egress Ip addresses.
 * @property sftpConfigs Object containing the following attributes:
 * @property tags Object containing the following attributes:
 * @property url URL of the partner's AS2 or SFTP endpoint.
 */
public data class GetConnectorResult(
    public val accessRole: String,
    public val arn: String,
    public val as2Configs: List<GetConnectorAs2Config>,
    public val id: String,
    public val loggingRole: String,
    public val securityPolicyName: String,
    public val serviceManagedEgressIpAddresses: List<String>,
    public val sftpConfigs: List<GetConnectorSftpConfig>,
    public val tags: Map<String, String>,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.GetConnectorResult): GetConnectorResult = GetConnectorResult(
            accessRole = javaType.accessRole(),
            arn = javaType.arn(),
            as2Configs = javaType.as2Configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.GetConnectorAs2Config.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            loggingRole = javaType.loggingRole(),
            securityPolicyName = javaType.securityPolicyName(),
            serviceManagedEgressIpAddresses = javaType.serviceManagedEgressIpAddresses().map({ args0 ->
                args0
            }),
            sftpConfigs = javaType.sftpConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.GetConnectorSftpConfig.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            url = javaType.url(),
        )
    }
}
