@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property trustedHostKeys List of the public portions of the host keys that are used to identify the servers the connector is connected to.
 * @property userSecretId Identifer for the secret in AWS Secrets Manager that contains the SFTP user's private key, and/or password.
 */
public data class GetConnectorSftpConfig(
    public val trustedHostKeys: List<String>,
    public val userSecretId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.GetConnectorSftpConfig): GetConnectorSftpConfig = GetConnectorSftpConfig(
            trustedHostKeys = javaType.trustedHostKeys().map({ args0 -> args0 }),
            userSecretId = javaType.userSecretId(),
        )
    }
}
