@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServer.
 * @property arn ARN of Transfer Server.
 * @property certificate ARN of any certificate.
 * @property domain The domain of the storage system that is used for file transfers.
 * @property endpoint Endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`).
 * @property endpointType Type of endpoint that the server is connected to.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityProviderType The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice.
 * @property invocationRole ARN of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
 * @property loggingRole ARN of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
 * @property protocols File transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
 * @property securityPolicyName The name of the security policy that is attached to the server.
 * @property serverId
 * @property structuredLogDestinations A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs.
 * @property url URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
 */
public data class GetServerResult(
    public val arn: String,
    public val certificate: String,
    public val domain: String,
    public val endpoint: String,
    public val endpointType: String,
    public val id: String,
    public val identityProviderType: String,
    public val invocationRole: String,
    public val loggingRole: String,
    public val protocols: List<String>,
    public val securityPolicyName: String,
    public val serverId: String,
    public val structuredLogDestinations: List<String>,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.GetServerResult): GetServerResult = GetServerResult(
            arn = javaType.arn(),
            certificate = javaType.certificate(),
            domain = javaType.domain(),
            endpoint = javaType.endpoint(),
            endpointType = javaType.endpointType(),
            id = javaType.id(),
            identityProviderType = javaType.identityProviderType(),
            invocationRole = javaType.invocationRole(),
            loggingRole = javaType.loggingRole(),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            securityPolicyName = javaType.securityPolicyName(),
            serverId = javaType.serverId(),
            structuredLogDestinations = javaType.structuredLogDestinations().map({ args0 -> args0 }),
            url = javaType.url(),
        )
    }
}
