@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property as2Transports Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
 * @property passiveIp Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
 * @property setStatOption Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
 * @property tlsSessionResumptionMode A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
 */
public data class ServerProtocolDetails(
    public val as2Transports: List<String>? = null,
    public val passiveIp: String? = null,
    public val setStatOption: String? = null,
    public val tlsSessionResumptionMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ServerProtocolDetails): ServerProtocolDetails = ServerProtocolDetails(
            as2Transports = javaType.as2Transports().map({ args0 -> args0 }),
            passiveIp = javaType.passiveIp().map({ args0 -> args0 }).orElse(null),
            setStatOption = javaType.setStatOption().map({ args0 -> args0 }).orElse(null),
            tlsSessionResumptionMode = javaType.tlsSessionResumptionMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
