@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property directoryListingOptimization Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.
 * By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
 */
public data class ServerS3StorageOptions(
    public val directoryListingOptimization: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ServerS3StorageOptions): ServerS3StorageOptions = ServerS3StorageOptions(
            directoryListingOptimization = javaType.directoryListingOptimization().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
