@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property executionRole Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
 * @property workflowId A unique identifier for the workflow.
 */
public data class ServerWorkflowDetailsOnPartialUpload(
    public val executionRole: String,
    public val workflowId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ServerWorkflowDetailsOnPartialUpload): ServerWorkflowDetailsOnPartialUpload = ServerWorkflowDetailsOnPartialUpload(
            executionRole = javaType.executionRole(),
            workflowId = javaType.workflowId(),
        )
    }
}
