@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entry Represents an entry and a target.
 * @property target Represents the map target.
 * The `Restricted` option is achieved using the following mapping:
 * ```
 * home_directory_mappings {
 * entry  = "/"
 * target = "/${aws_s3_bucket.foo.id}/$${Transfer:UserName}"
 * }
 * ```
 */
public data class UserHomeDirectoryMapping(
    public val entry: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.UserHomeDirectoryMapping): UserHomeDirectoryMapping = UserHomeDirectoryMapping(
            entry = javaType.entry(),
            target = javaType.target(),
        )
    }
}
