@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property copyStepDetails Details for a step that performs a file copy. See Copy Step Details below.
 * @property customStepDetails Details for a step that invokes a lambda function.
 * @property decryptStepDetails Details for a step that decrypts the file.
 * @property deleteStepDetails Details for a step that deletes the file.
 * @property tagStepDetails Details for a step that creates one or more tags.
 * @property type
 */
public data class WorkflowOnExceptionStep(
    public val copyStepDetails: WorkflowOnExceptionStepCopyStepDetails? = null,
    public val customStepDetails: WorkflowOnExceptionStepCustomStepDetails? = null,
    public val decryptStepDetails: WorkflowOnExceptionStepDecryptStepDetails? = null,
    public val deleteStepDetails: WorkflowOnExceptionStepDeleteStepDetails? = null,
    public val tagStepDetails: WorkflowOnExceptionStepTagStepDetails? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowOnExceptionStep): WorkflowOnExceptionStep = WorkflowOnExceptionStep(
            copyStepDetails = javaType.copyStepDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowOnExceptionStepCopyStepDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customStepDetails = javaType.customStepDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowOnExceptionStepCustomStepDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            decryptStepDetails = javaType.decryptStepDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowOnExceptionStepDecryptStepDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deleteStepDetails = javaType.deleteStepDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowOnExceptionStepDeleteStepDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tagStepDetails = javaType.tagStepDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowOnExceptionStepTagStepDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
