@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointLoadBalancerOptions
import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointNetworkInterfaceOptions
import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointSseSpecification
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointLoadBalancerOptions.Companion.toKotlin as endpointLoadBalancerOptionsToKotlin
import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointNetworkInterfaceOptions.Companion.toKotlin as endpointNetworkInterfaceOptionsToKotlin
import com.pulumi.aws.verifiedaccess.kotlin.outputs.EndpointSseSpecification.Companion.toKotlin as endpointSseSpecificationToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.aws.verifiedaccess.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS EC2 (Elastic Compute Cloud) Verified Access Endpoint.
 * ## Example Usage
 * ### ALB Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Endpoint("example", {
 *     applicationDomain: "example.com",
 *     attachmentType: "vpc",
 *     description: "example",
 *     domainCertificateArn: exampleAwsAcmCertificate.arn,
 *     endpointDomainPrefix: "example",
 *     endpointType: "load-balancer",
 *     loadBalancerOptions: {
 *         loadBalancerArn: exampleAwsLb.arn,
 *         port: 443,
 *         protocol: "https",
 *         subnetIds: .map(subnet => (subnet.id)),
 *     },
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     verifiedAccessGroupId: exampleAwsVerifiedaccessGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Endpoint("example",
 *     application_domain="example.com",
 *     attachment_type="vpc",
 *     description="example",
 *     domain_certificate_arn=example_aws_acm_certificate["arn"],
 *     endpoint_domain_prefix="example",
 *     endpoint_type="load-balancer",
 *     load_balancer_options={
 *         "load_balancer_arn": example_aws_lb["arn"],
 *         "port": 443,
 *         "protocol": "https",
 *         "subnet_ids": [subnet["id"] for subnet in public],
 *     },
 *     security_group_ids=[example_aws_security_group["id"]],
 *     verified_access_group_id=example_aws_verifiedaccess_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Endpoint("example", new()
 *     {
 *         ApplicationDomain = "example.com",
 *         AttachmentType = "vpc",
 *         Description = "example",
 *         DomainCertificateArn = exampleAwsAcmCertificate.Arn,
 *         EndpointDomainPrefix = "example",
 *         EndpointType = "load-balancer",
 *         LoadBalancerOptions = new Aws.VerifiedAccess.Inputs.EndpointLoadBalancerOptionsArgs
 *         {
 *             LoadBalancerArn = exampleAwsLb.Arn,
 *             Port = 443,
 *             Protocol = "https",
 *             SubnetIds = .Select(subnet =>
 *             {
 *                 return subnet.Id;
 *             }).ToList(),
 *         },
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VerifiedAccessGroupId = exampleAwsVerifiedaccessGroup.Id,
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Network Interface Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Endpoint("example", {
 *     applicationDomain: "example.com",
 *     attachmentType: "vpc",
 *     description: "example",
 *     domainCertificateArn: exampleAwsAcmCertificate.arn,
 *     endpointDomainPrefix: "example",
 *     endpointType: "network-interface",
 *     networkInterfaceOptions: {
 *         networkInterfaceId: exampleAwsNetworkInterface.id,
 *         port: 443,
 *         protocol: "https",
 *     },
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     verifiedAccessGroupId: exampleAwsVerifiedaccessGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Endpoint("example",
 *     application_domain="example.com",
 *     attachment_type="vpc",
 *     description="example",
 *     domain_certificate_arn=example_aws_acm_certificate["arn"],
 *     endpoint_domain_prefix="example",
 *     endpoint_type="network-interface",
 *     network_interface_options={
 *         "network_interface_id": example_aws_network_interface["id"],
 *         "port": 443,
 *         "protocol": "https",
 *     },
 *     security_group_ids=[example_aws_security_group["id"]],
 *     verified_access_group_id=example_aws_verifiedaccess_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Endpoint("example", new()
 *     {
 *         ApplicationDomain = "example.com",
 *         AttachmentType = "vpc",
 *         Description = "example",
 *         DomainCertificateArn = exampleAwsAcmCertificate.Arn,
 *         EndpointDomainPrefix = "example",
 *         EndpointType = "network-interface",
 *         NetworkInterfaceOptions = new Aws.VerifiedAccess.Inputs.EndpointNetworkInterfaceOptionsArgs
 *         {
 *             NetworkInterfaceId = exampleAwsNetworkInterface.Id,
 *             Port = 443,
 *             Protocol = "https",
 *         },
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VerifiedAccessGroupId = exampleAwsVerifiedaccessGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedaccess"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedaccess.NewEndpoint(ctx, "example", &verifiedaccess.EndpointArgs{
 * 			ApplicationDomain:    pulumi.String("example.com"),
 * 			AttachmentType:       pulumi.String("vpc"),
 * 			Description:          pulumi.String("example"),
 * 			DomainCertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 			EndpointDomainPrefix: pulumi.String("example"),
 * 			EndpointType:         pulumi.String("network-interface"),
 * 			NetworkInterfaceOptions: &verifiedaccess.EndpointNetworkInterfaceOptionsArgs{
 * 				NetworkInterfaceId: pulumi.Any(exampleAwsNetworkInterface.Id),
 * 				Port:               pulumi.Int(443),
 * 				Protocol:           pulumi.String("https"),
 * 			},
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VerifiedAccessGroupId: pulumi.Any(exampleAwsVerifiedaccessGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Endpoint;
 * import com.pulumi.aws.verifiedaccess.EndpointArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .applicationDomain("example.com")
 *             .attachmentType("vpc")
 *             .description("example")
 *             .domainCertificateArn(exampleAwsAcmCertificate.arn())
 *             .endpointDomainPrefix("example")
 *             .endpointType("network-interface")
 *             .networkInterfaceOptions(EndpointNetworkInterfaceOptionsArgs.builder()
 *                 .networkInterfaceId(exampleAwsNetworkInterface.id())
 *                 .port(443)
 *                 .protocol("https")
 *                 .build())
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .verifiedAccessGroupId(exampleAwsVerifiedaccessGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedaccess:Endpoint
 *     properties:
 *       applicationDomain: example.com
 *       attachmentType: vpc
 *       description: example
 *       domainCertificateArn: ${exampleAwsAcmCertificate.arn}
 *       endpointDomainPrefix: example
 *       endpointType: network-interface
 *       networkInterfaceOptions:
 *         networkInterfaceId: ${exampleAwsNetworkInterface.id}
 *         port: 443
 *         protocol: https
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       verifiedAccessGroupId: ${exampleAwsVerifiedaccessGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Access Instances using the  `id`. For example:
 * ```sh
 * $ pulumi import aws:verifiedaccess/endpoint:Endpoint example vae-8012925589
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.aws.verifiedaccess.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * The DNS name for users to reach your application.
     */
    public val applicationDomain: Output<String>
        get() = javaResource.applicationDomain().applyValue({ args0 -> args0 })

    /**
     * The type of attachment. Currently, only `vpc` is supported.
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * A description for the Verified Access endpoint.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Returned if endpoint has a device trust provider attached.
     */
    public val deviceValidationDomain: Output<String>
        get() = javaResource.deviceValidationDomain().applyValue({ args0 -> args0 })

    /**
     * The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
     */
    public val domainCertificateArn: Output<String>
        get() = javaResource.domainCertificateArn().applyValue({ args0 -> args0 })

    /**
     * A DNS name that is generated for the endpoint.
     */
    public val endpointDomain: Output<String>
        get() = javaResource.endpointDomain().applyValue({ args0 -> args0 })

    /**
     * A custom identifier that is prepended to the DNS name that is generated for the endpoint.
     */
    public val endpointDomainPrefix: Output<String>
        get() = javaResource.endpointDomainPrefix().applyValue({ args0 -> args0 })

    /**
     * The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
     */
    public val loadBalancerOptions: Output<EndpointLoadBalancerOptions>?
        get() = javaResource.loadBalancerOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointLoadBalancerOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The network interface details. This parameter is required if the endpoint type is `network-interface`.
     */
    public val networkInterfaceOptions: Output<EndpointNetworkInterfaceOptions>?
        get() = javaResource.networkInterfaceOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointNetworkInterfaceOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The policy document that is associated with this resource.
     */
    public val policyDocument: Output<String>?
        get() = javaResource.policyDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of the the security groups IDs to associate with the Verified Access endpoint.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The options in use for server side encryption.
     */
    public val sseSpecification: Output<EndpointSseSpecification>
        get() = javaResource.sseSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointSseSpecificationToKotlin(args0)
            })
        })

    /**
     * Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the Verified Access group to associate the endpoint with.
     * The following arguments are optional:
     */
    public val verifiedAccessGroupId: Output<String>
        get() = javaResource.verifiedAccessGroupId().applyValue({ args0 -> args0 })

    public val verifiedAccessInstanceId: Output<String>
        get() = javaResource.verifiedAccessInstanceId().applyValue({ args0 -> args0 })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedaccess.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.aws.verifiedaccess.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
