@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.EndpointArgs.builder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointLoadBalancerOptionsArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointLoadBalancerOptionsArgsBuilder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointNetworkInterfaceOptionsArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointNetworkInterfaceOptionsArgsBuilder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointSseSpecificationArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.EndpointSseSpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS EC2 (Elastic Compute Cloud) Verified Access Endpoint.
 * ## Example Usage
 * ### ALB Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Endpoint("example", {
 *     applicationDomain: "example.com",
 *     attachmentType: "vpc",
 *     description: "example",
 *     domainCertificateArn: exampleAwsAcmCertificate.arn,
 *     endpointDomainPrefix: "example",
 *     endpointType: "load-balancer",
 *     loadBalancerOptions: {
 *         loadBalancerArn: exampleAwsLb.arn,
 *         port: 443,
 *         protocol: "https",
 *         subnetIds: .map(subnet => (subnet.id)),
 *     },
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     verifiedAccessGroupId: exampleAwsVerifiedaccessGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Endpoint("example",
 *     application_domain="example.com",
 *     attachment_type="vpc",
 *     description="example",
 *     domain_certificate_arn=example_aws_acm_certificate["arn"],
 *     endpoint_domain_prefix="example",
 *     endpoint_type="load-balancer",
 *     load_balancer_options={
 *         "load_balancer_arn": example_aws_lb["arn"],
 *         "port": 443,
 *         "protocol": "https",
 *         "subnet_ids": [subnet["id"] for subnet in public],
 *     },
 *     security_group_ids=[example_aws_security_group["id"]],
 *     verified_access_group_id=example_aws_verifiedaccess_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Endpoint("example", new()
 *     {
 *         ApplicationDomain = "example.com",
 *         AttachmentType = "vpc",
 *         Description = "example",
 *         DomainCertificateArn = exampleAwsAcmCertificate.Arn,
 *         EndpointDomainPrefix = "example",
 *         EndpointType = "load-balancer",
 *         LoadBalancerOptions = new Aws.VerifiedAccess.Inputs.EndpointLoadBalancerOptionsArgs
 *         {
 *             LoadBalancerArn = exampleAwsLb.Arn,
 *             Port = 443,
 *             Protocol = "https",
 *             SubnetIds = .Select(subnet =>
 *             {
 *                 return subnet.Id;
 *             }).ToList(),
 *         },
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VerifiedAccessGroupId = exampleAwsVerifiedaccessGroup.Id,
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Network Interface Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Endpoint("example", {
 *     applicationDomain: "example.com",
 *     attachmentType: "vpc",
 *     description: "example",
 *     domainCertificateArn: exampleAwsAcmCertificate.arn,
 *     endpointDomainPrefix: "example",
 *     endpointType: "network-interface",
 *     networkInterfaceOptions: {
 *         networkInterfaceId: exampleAwsNetworkInterface.id,
 *         port: 443,
 *         protocol: "https",
 *     },
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     verifiedAccessGroupId: exampleAwsVerifiedaccessGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Endpoint("example",
 *     application_domain="example.com",
 *     attachment_type="vpc",
 *     description="example",
 *     domain_certificate_arn=example_aws_acm_certificate["arn"],
 *     endpoint_domain_prefix="example",
 *     endpoint_type="network-interface",
 *     network_interface_options={
 *         "network_interface_id": example_aws_network_interface["id"],
 *         "port": 443,
 *         "protocol": "https",
 *     },
 *     security_group_ids=[example_aws_security_group["id"]],
 *     verified_access_group_id=example_aws_verifiedaccess_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Endpoint("example", new()
 *     {
 *         ApplicationDomain = "example.com",
 *         AttachmentType = "vpc",
 *         Description = "example",
 *         DomainCertificateArn = exampleAwsAcmCertificate.Arn,
 *         EndpointDomainPrefix = "example",
 *         EndpointType = "network-interface",
 *         NetworkInterfaceOptions = new Aws.VerifiedAccess.Inputs.EndpointNetworkInterfaceOptionsArgs
 *         {
 *             NetworkInterfaceId = exampleAwsNetworkInterface.Id,
 *             Port = 443,
 *             Protocol = "https",
 *         },
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VerifiedAccessGroupId = exampleAwsVerifiedaccessGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedaccess"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedaccess.NewEndpoint(ctx, "example", &verifiedaccess.EndpointArgs{
 * 			ApplicationDomain:    pulumi.String("example.com"),
 * 			AttachmentType:       pulumi.String("vpc"),
 * 			Description:          pulumi.String("example"),
 * 			DomainCertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 			EndpointDomainPrefix: pulumi.String("example"),
 * 			EndpointType:         pulumi.String("network-interface"),
 * 			NetworkInterfaceOptions: &verifiedaccess.EndpointNetworkInterfaceOptionsArgs{
 * 				NetworkInterfaceId: pulumi.Any(exampleAwsNetworkInterface.Id),
 * 				Port:               pulumi.Int(443),
 * 				Protocol:           pulumi.String("https"),
 * 			},
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VerifiedAccessGroupId: pulumi.Any(exampleAwsVerifiedaccessGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Endpoint;
 * import com.pulumi.aws.verifiedaccess.EndpointArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .applicationDomain("example.com")
 *             .attachmentType("vpc")
 *             .description("example")
 *             .domainCertificateArn(exampleAwsAcmCertificate.arn())
 *             .endpointDomainPrefix("example")
 *             .endpointType("network-interface")
 *             .networkInterfaceOptions(EndpointNetworkInterfaceOptionsArgs.builder()
 *                 .networkInterfaceId(exampleAwsNetworkInterface.id())
 *                 .port(443)
 *                 .protocol("https")
 *                 .build())
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .verifiedAccessGroupId(exampleAwsVerifiedaccessGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedaccess:Endpoint
 *     properties:
 *       applicationDomain: example.com
 *       attachmentType: vpc
 *       description: example
 *       domainCertificateArn: ${exampleAwsAcmCertificate.arn}
 *       endpointDomainPrefix: example
 *       endpointType: network-interface
 *       networkInterfaceOptions:
 *         networkInterfaceId: ${exampleAwsNetworkInterface.id}
 *         port: 443
 *         protocol: https
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       verifiedAccessGroupId: ${exampleAwsVerifiedaccessGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Access Instances using the  `id`. For example:
 * ```sh
 * $ pulumi import aws:verifiedaccess/endpoint:Endpoint example vae-8012925589
 * ```
 * @property applicationDomain The DNS name for users to reach your application.
 * @property attachmentType The type of attachment. Currently, only `vpc` is supported.
 * @property description A description for the Verified Access endpoint.
 * @property domainCertificateArn The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
 * @property endpointDomainPrefix A custom identifier that is prepended to the DNS name that is generated for the endpoint.
 * @property endpointType The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
 * @property loadBalancerOptions The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
 * @property networkInterfaceOptions The network interface details. This parameter is required if the endpoint type is `network-interface`.
 * @property policyDocument The policy document that is associated with this resource.
 * @property securityGroupIds List of the the security groups IDs to associate with the Verified Access endpoint.
 * @property sseSpecification The options in use for server side encryption.
 * @property tags Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property verifiedAccessGroupId The ID of the Verified Access group to associate the endpoint with.
 * The following arguments are optional:
 */
public data class EndpointArgs(
    public val applicationDomain: Output<String>? = null,
    public val attachmentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val domainCertificateArn: Output<String>? = null,
    public val endpointDomainPrefix: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val loadBalancerOptions: Output<EndpointLoadBalancerOptionsArgs>? = null,
    public val networkInterfaceOptions: Output<EndpointNetworkInterfaceOptionsArgs>? = null,
    public val policyDocument: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val sseSpecification: Output<EndpointSseSpecificationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val verifiedAccessGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.EndpointArgs =
        com.pulumi.aws.verifiedaccess.EndpointArgs.builder()
            .applicationDomain(applicationDomain?.applyValue({ args0 -> args0 }))
            .attachmentType(attachmentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domainCertificateArn(domainCertificateArn?.applyValue({ args0 -> args0 }))
            .endpointDomainPrefix(endpointDomainPrefix?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .loadBalancerOptions(
                loadBalancerOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkInterfaceOptions(
                networkInterfaceOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sseSpecification(sseSpecification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .verifiedAccessGroupId(verifiedAccessGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var applicationDomain: Output<String>? = null

    private var attachmentType: Output<String>? = null

    private var description: Output<String>? = null

    private var domainCertificateArn: Output<String>? = null

    private var endpointDomainPrefix: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var loadBalancerOptions: Output<EndpointLoadBalancerOptionsArgs>? = null

    private var networkInterfaceOptions: Output<EndpointNetworkInterfaceOptionsArgs>? = null

    private var policyDocument: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var sseSpecification: Output<EndpointSseSpecificationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var verifiedAccessGroupId: Output<String>? = null

    /**
     * @param value The DNS name for users to reach your application.
     */
    @JvmName("nexxctvnovjmdrgk")
    public suspend fun applicationDomain(`value`: Output<String>) {
        this.applicationDomain = value
    }

    /**
     * @param value The type of attachment. Currently, only `vpc` is supported.
     */
    @JvmName("nkmtbufmubcyfahw")
    public suspend fun attachmentType(`value`: Output<String>) {
        this.attachmentType = value
    }

    /**
     * @param value A description for the Verified Access endpoint.
     */
    @JvmName("wakvpxeyqbjowfpw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
     */
    @JvmName("wrxxuutqfxwrgumv")
    public suspend fun domainCertificateArn(`value`: Output<String>) {
        this.domainCertificateArn = value
    }

    /**
     * @param value A custom identifier that is prepended to the DNS name that is generated for the endpoint.
     */
    @JvmName("otxcvedjygoxvgjr")
    public suspend fun endpointDomainPrefix(`value`: Output<String>) {
        this.endpointDomainPrefix = value
    }

    /**
     * @param value The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
     */
    @JvmName("xxalhqfkwfkcnphk")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
     */
    @JvmName("qouqgmcwqldaxvtk")
    public suspend fun loadBalancerOptions(`value`: Output<EndpointLoadBalancerOptionsArgs>) {
        this.loadBalancerOptions = value
    }

    /**
     * @param value The network interface details. This parameter is required if the endpoint type is `network-interface`.
     */
    @JvmName("ytfwvytystpfjhsy")
    public suspend fun networkInterfaceOptions(`value`: Output<EndpointNetworkInterfaceOptionsArgs>) {
        this.networkInterfaceOptions = value
    }

    /**
     * @param value The policy document that is associated with this resource.
     */
    @JvmName("bwjpwvwjtipodrfi")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value List of the the security groups IDs to associate with the Verified Access endpoint.
     */
    @JvmName("oahgovjeeyvxyuuy")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("acdhvggdvpbwgxgh")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of the the security groups IDs to associate with the Verified Access endpoint.
     */
    @JvmName("theghdwnphtvelsa")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The options in use for server side encryption.
     */
    @JvmName("qfsbbplnrfekddbj")
    public suspend fun sseSpecification(`value`: Output<EndpointSseSpecificationArgs>) {
        this.sseSpecification = value
    }

    /**
     * @param value Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jjcguipvacxyluhr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Verified Access group to associate the endpoint with.
     * The following arguments are optional:
     */
    @JvmName("dfdwaqviwhbuxegn")
    public suspend fun verifiedAccessGroupId(`value`: Output<String>) {
        this.verifiedAccessGroupId = value
    }

    /**
     * @param value The DNS name for users to reach your application.
     */
    @JvmName("sgrgutekhutputfm")
    public suspend fun applicationDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationDomain = mapped
    }

    /**
     * @param value The type of attachment. Currently, only `vpc` is supported.
     */
    @JvmName("wkkopmxypxjxhrcr")
    public suspend fun attachmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentType = mapped
    }

    /**
     * @param value A description for the Verified Access endpoint.
     */
    @JvmName("ytelhqmmkxdhywqa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
     */
    @JvmName("hprugcelvjjdrsjt")
    public suspend fun domainCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainCertificateArn = mapped
    }

    /**
     * @param value A custom identifier that is prepended to the DNS name that is generated for the endpoint.
     */
    @JvmName("bbtftewaurswxcyk")
    public suspend fun endpointDomainPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointDomainPrefix = mapped
    }

    /**
     * @param value The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
     */
    @JvmName("ujebpxkoolsymlqx")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
     */
    @JvmName("ygpqsgskfyfoycaa")
    public suspend fun loadBalancerOptions(`value`: EndpointLoadBalancerOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerOptions = mapped
    }

    /**
     * @param argument The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
     */
    @JvmName("prgcyxmcmtsjmsoo")
    public suspend fun loadBalancerOptions(argument: suspend EndpointLoadBalancerOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointLoadBalancerOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerOptions = mapped
    }

    /**
     * @param value The network interface details. This parameter is required if the endpoint type is `network-interface`.
     */
    @JvmName("vahkhcxnmcbscnvt")
    public suspend fun networkInterfaceOptions(`value`: EndpointNetworkInterfaceOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceOptions = mapped
    }

    /**
     * @param argument The network interface details. This parameter is required if the endpoint type is `network-interface`.
     */
    @JvmName("fjqciekoskcdsppf")
    public suspend fun networkInterfaceOptions(argument: suspend EndpointNetworkInterfaceOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointNetworkInterfaceOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaceOptions = mapped
    }

    /**
     * @param value The policy document that is associated with this resource.
     */
    @JvmName("bptbalithgeajnuu")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value List of the the security groups IDs to associate with the Verified Access endpoint.
     */
    @JvmName("hpjoyowrienjnsxv")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of the the security groups IDs to associate with the Verified Access endpoint.
     */
    @JvmName("qkkyfjgeiluyxvip")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The options in use for server side encryption.
     */
    @JvmName("cyutubquomajahbr")
    public suspend fun sseSpecification(`value`: EndpointSseSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseSpecification = mapped
    }

    /**
     * @param argument The options in use for server side encryption.
     */
    @JvmName("hschuabnwhvrdycw")
    public suspend fun sseSpecification(argument: suspend EndpointSseSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointSseSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sseSpecification = mapped
    }

    /**
     * @param value Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xsdwabyvootysidb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uagexgphaesvcywo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Verified Access group to associate the endpoint with.
     * The following arguments are optional:
     */
    @JvmName("gsipsuwitfhlailm")
    public suspend fun verifiedAccessGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedAccessGroupId = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        applicationDomain = applicationDomain,
        attachmentType = attachmentType,
        description = description,
        domainCertificateArn = domainCertificateArn,
        endpointDomainPrefix = endpointDomainPrefix,
        endpointType = endpointType,
        loadBalancerOptions = loadBalancerOptions,
        networkInterfaceOptions = networkInterfaceOptions,
        policyDocument = policyDocument,
        securityGroupIds = securityGroupIds,
        sseSpecification = sseSpecification,
        tags = tags,
        verifiedAccessGroupId = verifiedAccessGroupId,
    )
}
