@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.kotlin.outputs.GroupSseConfiguration
import com.pulumi.aws.verifiedaccess.kotlin.outputs.GroupSseConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.aws.verifiedaccess.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * Resource for managing a Verified Access Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Group("example", {verifiedaccessInstanceId: exampleAwsVerifiedaccessInstance.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Group("example", verifiedaccess_instance_id=example_aws_verifiedaccess_instance["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Group("example", new()
 *     {
 *         VerifiedaccessInstanceId = exampleAwsVerifiedaccessInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedaccess"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedaccess.NewGroup(ctx, "example", &verifiedaccess.GroupArgs{
 * 			VerifiedaccessInstanceId: pulumi.Any(exampleAwsVerifiedaccessInstance.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Group;
 * import com.pulumi.aws.verifiedaccess.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .verifiedaccessInstanceId(exampleAwsVerifiedaccessInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedaccess:Group
 *     properties:
 *       verifiedaccessInstanceId: ${exampleAwsVerifiedaccessInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with KMS Key
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   testKey:
 *     type: aws:kms:Key
 *     name: test_key
 *     properties:
 *       description: KMS key for Verified Access Group test
 *   test:
 *     type: aws:verifiedaccess:Group
 *     properties:
 *       verifiedaccessInstanceId: ${testAwsVerifiedaccessInstanceTrustProviderAttachment.verifiedaccessInstanceId}
 *       serverSideEncryptionConfiguration:
 *         - kmsKeyArn: ${testKey.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.aws.verifiedaccess.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * Timestamp when the access group was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Timestamp when the access group was deleted.
     */
    public val deletionTime: Output<String>
        get() = javaResource.deletionTime().applyValue({ args0 -> args0 })

    /**
     * Description of the verified access group.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Timestamp when the access group was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * AWS account number owning this resource.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The policy document that is associated with this resource.
     */
    public val policyDocument: Output<String>?
        get() = javaResource.policyDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block to use KMS keys for server-side encryption.
     */
    public val sseConfiguration: Output<GroupSseConfiguration>
        get() = javaResource.sseConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ARN of this verified acess group.
     */
    public val verifiedaccessGroupArn: Output<String>
        get() = javaResource.verifiedaccessGroupArn().applyValue({ args0 -> args0 })

    /**
     * ID of this verified access group.
     */
    public val verifiedaccessGroupId: Output<String>
        get() = javaResource.verifiedaccessGroupId().applyValue({ args0 -> args0 })

    /**
     * The id of the verified access instance this group is associated with.
     * The following arguments are optional:
     */
    public val verifiedaccessInstanceId: Output<String>
        get() = javaResource.verifiedaccessInstanceId().applyValue({ args0 -> args0 })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedaccess.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(
        javaResource as
            com.pulumi.aws.verifiedaccess.Group,
    )
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
