@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.GroupArgs.builder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.GroupSseConfigurationArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.GroupSseConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Group("example", {verifiedaccessInstanceId: exampleAwsVerifiedaccessInstance.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Group("example", verifiedaccess_instance_id=example_aws_verifiedaccess_instance["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Group("example", new()
 *     {
 *         VerifiedaccessInstanceId = exampleAwsVerifiedaccessInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedaccess"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedaccess.NewGroup(ctx, "example", &verifiedaccess.GroupArgs{
 * 			VerifiedaccessInstanceId: pulumi.Any(exampleAwsVerifiedaccessInstance.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Group;
 * import com.pulumi.aws.verifiedaccess.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .verifiedaccessInstanceId(exampleAwsVerifiedaccessInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedaccess:Group
 *     properties:
 *       verifiedaccessInstanceId: ${exampleAwsVerifiedaccessInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with KMS Key
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   testKey:
 *     type: aws:kms:Key
 *     name: test_key
 *     properties:
 *       description: KMS key for Verified Access Group test
 *   test:
 *     type: aws:verifiedaccess:Group
 *     properties:
 *       verifiedaccessInstanceId: ${testAwsVerifiedaccessInstanceTrustProviderAttachment.verifiedaccessInstanceId}
 *       serverSideEncryptionConfiguration:
 *         - kmsKeyArn: ${testKey.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property description Description of the verified access group.
 * @property policyDocument The policy document that is associated with this resource.
 * @property sseConfiguration Configuration block to use KMS keys for server-side encryption.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property verifiedaccessInstanceId The id of the verified access instance this group is associated with.
 * The following arguments are optional:
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val sseConfiguration: Output<GroupSseConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val verifiedaccessInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.GroupArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.GroupArgs =
        com.pulumi.aws.verifiedaccess.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .sseConfiguration(sseConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .verifiedaccessInstanceId(verifiedaccessInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var sseConfiguration: Output<GroupSseConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var verifiedaccessInstanceId: Output<String>? = null

    /**
     * @param value Description of the verified access group.
     */
    @JvmName("jkjodcikvieujhrb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The policy document that is associated with this resource.
     */
    @JvmName("ejrtsksbtmhxplro")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value Configuration block to use KMS keys for server-side encryption.
     */
    @JvmName("jrfrfjrekehngeck")
    public suspend fun sseConfiguration(`value`: Output<GroupSseConfigurationArgs>) {
        this.sseConfiguration = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wsklgmxiojaxcsii")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The id of the verified access instance this group is associated with.
     * The following arguments are optional:
     */
    @JvmName("tqndbgjdofagolgr")
    public suspend fun verifiedaccessInstanceId(`value`: Output<String>) {
        this.verifiedaccessInstanceId = value
    }

    /**
     * @param value Description of the verified access group.
     */
    @JvmName("lbdompjhuddysdcw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The policy document that is associated with this resource.
     */
    @JvmName("nxkcipujpjqrgyvv")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value Configuration block to use KMS keys for server-side encryption.
     */
    @JvmName("spcpnwgxfjpurnru")
    public suspend fun sseConfiguration(`value`: GroupSseConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseConfiguration = mapped
    }

    /**
     * @param argument Configuration block to use KMS keys for server-side encryption.
     */
    @JvmName("viqagfqykvmcandr")
    public suspend fun sseConfiguration(argument: suspend GroupSseConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GroupSseConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sseConfiguration = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tusuuydftgebfxvi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yuhawexkmfcsmqwy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The id of the verified access instance this group is associated with.
     * The following arguments are optional:
     */
    @JvmName("hymhtxxqsujhduxc")
    public suspend fun verifiedaccessInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessInstanceId = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        policyDocument = policyDocument,
        sseConfiguration = sseConfiguration,
        tags = tags,
        verifiedaccessInstanceId = verifiedaccessInstanceId,
    )
}
