@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Instance Trust Provider Attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedaccess.Instance("example", {});
 * const exampleTrustProvider = new aws.verifiedaccess.TrustProvider("example", {
 *     deviceTrustProviderType: "jamf",
 *     policyReferenceName: "example",
 *     trustProviderType: "device",
 *     deviceOptions: {
 *         tenantId: "example",
 *     },
 * });
 * const exampleInstanceTrustProviderAttachment = new aws.verifiedaccess.InstanceTrustProviderAttachment("example", {
 *     verifiedaccessInstanceId: example.id,
 *     verifiedaccessTrustProviderId: exampleTrustProvider.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedaccess.Instance("example")
 * example_trust_provider = aws.verifiedaccess.TrustProvider("example",
 *     device_trust_provider_type="jamf",
 *     policy_reference_name="example",
 *     trust_provider_type="device",
 *     device_options={
 *         "tenant_id": "example",
 *     })
 * example_instance_trust_provider_attachment = aws.verifiedaccess.InstanceTrustProviderAttachment("example",
 *     verifiedaccess_instance_id=example.id,
 *     verifiedaccess_trust_provider_id=example_trust_provider.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedAccess.Instance("example");
 *     var exampleTrustProvider = new Aws.VerifiedAccess.TrustProvider("example", new()
 *     {
 *         DeviceTrustProviderType = "jamf",
 *         PolicyReferenceName = "example",
 *         TrustProviderType = "device",
 *         DeviceOptions = new Aws.VerifiedAccess.Inputs.TrustProviderDeviceOptionsArgs
 *         {
 *             TenantId = "example",
 *         },
 *     });
 *     var exampleInstanceTrustProviderAttachment = new Aws.VerifiedAccess.InstanceTrustProviderAttachment("example", new()
 *     {
 *         VerifiedaccessInstanceId = example.Id,
 *         VerifiedaccessTrustProviderId = exampleTrustProvider.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedaccess"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := verifiedaccess.NewInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTrustProvider, err := verifiedaccess.NewTrustProvider(ctx, "example", &verifiedaccess.TrustProviderArgs{
 * 			DeviceTrustProviderType: pulumi.String("jamf"),
 * 			PolicyReferenceName:     pulumi.String("example"),
 * 			TrustProviderType:       pulumi.String("device"),
 * 			DeviceOptions: &verifiedaccess.TrustProviderDeviceOptionsArgs{
 * 				TenantId: pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = verifiedaccess.NewInstanceTrustProviderAttachment(ctx, "example", &verifiedaccess.InstanceTrustProviderAttachmentArgs{
 * 			VerifiedaccessInstanceId:      example.ID(),
 * 			VerifiedaccessTrustProviderId: exampleTrustProvider.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Instance;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example");
 *         var exampleTrustProvider = new TrustProvider("exampleTrustProvider", TrustProviderArgs.builder()
 *             .deviceTrustProviderType("jamf")
 *             .policyReferenceName("example")
 *             .trustProviderType("device")
 *             .deviceOptions(TrustProviderDeviceOptionsArgs.builder()
 *                 .tenantId("example")
 *                 .build())
 *             .build());
 *         var exampleInstanceTrustProviderAttachment = new InstanceTrustProviderAttachment("exampleInstanceTrustProviderAttachment", InstanceTrustProviderAttachmentArgs.builder()
 *             .verifiedaccessInstanceId(example.id())
 *             .verifiedaccessTrustProviderId(exampleTrustProvider.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedaccess:Instance
 *   exampleTrustProvider:
 *     type: aws:verifiedaccess:TrustProvider
 *     name: example
 *     properties:
 *       deviceTrustProviderType: jamf
 *       policyReferenceName: example
 *       trustProviderType: device
 *       deviceOptions:
 *         tenantId: example
 *   exampleInstanceTrustProviderAttachment:
 *     type: aws:verifiedaccess:InstanceTrustProviderAttachment
 *     name: example
 *     properties:
 *       verifiedaccessInstanceId: ${example.id}
 *       verifiedaccessTrustProviderId: ${exampleTrustProvider.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Access Instance Trust Provider Attachments using the `verifiedaccess_instance_id` and `verifiedaccess_trust_provider_id` separated by a forward slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:verifiedaccess/instanceTrustProviderAttachment:InstanceTrustProviderAttachment example vai-1234567890abcdef0/vatp-8012925589
 * ```
 * @property verifiedaccessInstanceId The ID of the Verified Access instance to attach the Trust Provider to.
 * @property verifiedaccessTrustProviderId The ID of the Verified Access trust provider.
 */
public data class InstanceTrustProviderAttachmentArgs(
    public val verifiedaccessInstanceId: Output<String>? = null,
    public val verifiedaccessTrustProviderId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs =
        com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs.builder()
            .verifiedaccessInstanceId(verifiedaccessInstanceId?.applyValue({ args0 -> args0 }))
            .verifiedaccessTrustProviderId(
                verifiedaccessTrustProviderId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [InstanceTrustProviderAttachmentArgs].
 */
@PulumiTagMarker
public class InstanceTrustProviderAttachmentArgsBuilder internal constructor() {
    private var verifiedaccessInstanceId: Output<String>? = null

    private var verifiedaccessTrustProviderId: Output<String>? = null

    /**
     * @param value The ID of the Verified Access instance to attach the Trust Provider to.
     */
    @JvmName("jpornfrkqboujirm")
    public suspend fun verifiedaccessInstanceId(`value`: Output<String>) {
        this.verifiedaccessInstanceId = value
    }

    /**
     * @param value The ID of the Verified Access trust provider.
     */
    @JvmName("rwrwjnvmavpvaeyl")
    public suspend fun verifiedaccessTrustProviderId(`value`: Output<String>) {
        this.verifiedaccessTrustProviderId = value
    }

    /**
     * @param value The ID of the Verified Access instance to attach the Trust Provider to.
     */
    @JvmName("xwybfcpjqmmhvrtj")
    public suspend fun verifiedaccessInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessInstanceId = mapped
    }

    /**
     * @param value The ID of the Verified Access trust provider.
     */
    @JvmName("cuxvhjtqvwtftmhn")
    public suspend fun verifiedaccessTrustProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessTrustProviderId = mapped
    }

    internal fun build(): InstanceTrustProviderAttachmentArgs = InstanceTrustProviderAttachmentArgs(
        verifiedaccessInstanceId = verifiedaccessInstanceId,
        verifiedaccessTrustProviderId = verifiedaccessTrustProviderId,
    )
}
