@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.EndpointLoadBalancerOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property loadBalancerArn
 * @property port
 * @property protocol
 * @property subnetIds
 */
public data class EndpointLoadBalancerOptionsArgs(
    public val loadBalancerArn: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.EndpointLoadBalancerOptionsArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.EndpointLoadBalancerOptionsArgs =
        com.pulumi.aws.verifiedaccess.inputs.EndpointLoadBalancerOptionsArgs.builder()
            .loadBalancerArn(loadBalancerArn?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EndpointLoadBalancerOptionsArgs].
 */
@PulumiTagMarker
public class EndpointLoadBalancerOptionsArgsBuilder internal constructor() {
    private var loadBalancerArn: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("uliuruqixtvcruyi")
    public suspend fun loadBalancerArn(`value`: Output<String>) {
        this.loadBalancerArn = value
    }

    /**
     * @param value
     */
    @JvmName("gxxpsdrljdhfjeyv")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("hmfkabrkscpmbdyu")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("iasmlehpndrogsxe")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("blasyhyfgeotiiuf")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fshjfuvjmbosgjmc")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rbhnnuvtvgehyhwt")
    public suspend fun loadBalancerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcmiduopmvtookie")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("ncgvhofklgbmyath")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("ttgqfbwychgeiaoe")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("qfgssfloxfbvgeni")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): EndpointLoadBalancerOptionsArgs = EndpointLoadBalancerOptionsArgs(
        loadBalancerArn = loadBalancerArn,
        port = port,
        protocol = protocol,
        subnetIds = subnetIds,
    )
}
