@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkInterfaceId
 * @property port
 * @property protocol
 */
public data class EndpointNetworkInterfaceOptionsArgs(
    public val networkInterfaceId: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs =
        com.pulumi.aws.verifiedaccess.inputs.EndpointNetworkInterfaceOptionsArgs.builder()
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointNetworkInterfaceOptionsArgs].
 */
@PulumiTagMarker
public class EndpointNetworkInterfaceOptionsArgsBuilder internal constructor() {
    private var networkInterfaceId: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cxhgcxeaegneuxbb")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value
     */
    @JvmName("gamfhnnfdbpfqpfj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("ekxxgrxlocvyowaf")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("kgyyfuwnalhlsdgm")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("cbmqvvybgtxlftcn")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("olqawlvtpskrlafu")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): EndpointNetworkInterfaceOptionsArgs = EndpointNetworkInterfaceOptionsArgs(
        networkInterfaceId = networkInterfaceId,
        port = port,
        protocol = protocol,
    )
}
