@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.EndpointSseSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customerManagedKeyEnabled
 * @property kmsKeyArn
 */
public data class EndpointSseSpecificationArgs(
    public val customerManagedKeyEnabled: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.EndpointSseSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.EndpointSseSpecificationArgs =
        com.pulumi.aws.verifiedaccess.inputs.EndpointSseSpecificationArgs.builder()
            .customerManagedKeyEnabled(customerManagedKeyEnabled?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointSseSpecificationArgs].
 */
@PulumiTagMarker
public class EndpointSseSpecificationArgsBuilder internal constructor() {
    private var customerManagedKeyEnabled: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dsasgnjvufpietdn")
    public suspend fun customerManagedKeyEnabled(`value`: Output<Boolean>) {
        this.customerManagedKeyEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("qhqhjohamijxwhxr")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value
     */
    @JvmName("egiymaqtnfsnyvam")
    public suspend fun customerManagedKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKeyEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("ksemipfweavaewta")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): EndpointSseSpecificationArgs = EndpointSseSpecificationArgs(
        customerManagedKeyEnabled = customerManagedKeyEnabled,
        kmsKeyArn = kmsKeyArn,
    )
}
