@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.GroupSseConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customerManagedKeyEnabled
 * @property kmsKeyArn ARN of the KMS key to use.
 */
public data class GroupSseConfigurationArgs(
    public val customerManagedKeyEnabled: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.GroupSseConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.GroupSseConfigurationArgs =
        com.pulumi.aws.verifiedaccess.inputs.GroupSseConfigurationArgs.builder()
            .customerManagedKeyEnabled(customerManagedKeyEnabled?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupSseConfigurationArgs].
 */
@PulumiTagMarker
public class GroupSseConfigurationArgsBuilder internal constructor() {
    private var customerManagedKeyEnabled: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ataqmhwwtslycgyr")
    public suspend fun customerManagedKeyEnabled(`value`: Output<Boolean>) {
        this.customerManagedKeyEnabled = value
    }

    /**
     * @param value ARN of the KMS key to use.
     */
    @JvmName("uqpxtidadkwhlxna")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value
     */
    @JvmName("yfdcpnivqxlinxnr")
    public suspend fun customerManagedKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKeyEnabled = mapped
    }

    /**
     * @param value ARN of the KMS key to use.
     */
    @JvmName("drrhasvstpgkfebj")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): GroupSseConfigurationArgs = GroupSseConfigurationArgs(
        customerManagedKeyEnabled = customerManagedKeyEnabled,
        kmsKeyArn = kmsKeyArn,
    )
}
