@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tenantId
 */
public data class TrustProviderDeviceOptionsArgs(
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs =
        com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs.builder()
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustProviderDeviceOptionsArgs].
 */
@PulumiTagMarker
public class TrustProviderDeviceOptionsArgsBuilder internal constructor() {
    private var tenantId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vyyjfrbiwaysjuwj")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("yfbxttxcdmhrulxr")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): TrustProviderDeviceOptionsArgs = TrustProviderDeviceOptionsArgs(
        tenantId = tenantId,
    )
}
