@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customerManagedKeyEnabled
 * @property kmsKeyArn ARN of the KMS key to use.
 */
public data class GroupSseConfiguration(
    public val customerManagedKeyEnabled: Boolean? = null,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.GroupSseConfiguration): GroupSseConfiguration = GroupSseConfiguration(
            customerManagedKeyEnabled = javaType.customerManagedKeyEnabled().map({ args0 ->
                args0
            }).orElse(null),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
