@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description A description for the AWS Verified Access Instance.
 * @property deviceTrustProviderType The type of device-based trust provider.
 * @property trustProviderType The type of trust provider (user- or device-based).
 * @property userTrustProviderType The type of user-based trust provider.
 * @property verifiedAccessTrustProviderId The ID of the trust provider.
 */
public data class InstanceVerifiedAccessTrustProvider(
    public val description: String? = null,
    public val deviceTrustProviderType: String? = null,
    public val trustProviderType: String? = null,
    public val userTrustProviderType: String? = null,
    public val verifiedAccessTrustProviderId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.InstanceVerifiedAccessTrustProvider): InstanceVerifiedAccessTrustProvider = InstanceVerifiedAccessTrustProvider(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            deviceTrustProviderType = javaType.deviceTrustProviderType().map({ args0 -> args0 }).orElse(null),
            trustProviderType = javaType.trustProviderType().map({ args0 -> args0 }).orElse(null),
            userTrustProviderType = javaType.userTrustProviderType().map({ args0 -> args0 }).orElse(null),
            verifiedAccessTrustProviderId = javaType.verifiedAccessTrustProviderId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
