@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.PolicyArgs.builder
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.PolicyDefinitionArgs
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.PolicyDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Verified Permissions Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.verifiedpermissions.Policy("test", {
 *     policyStoreId: testAwsVerifiedpermissionsPolicyStore.id,
 *     definition: {
 *         static: {
 *             statement: "permit (principal, action == Action::\"view\", resource in Album:: \"test_album\");",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.verifiedpermissions.Policy("test",
 *     policy_store_id=test_aws_verifiedpermissions_policy_store["id"],
 *     definition={
 *         "static": {
 *             "statement": "permit (principal, action == Action::\"view\", resource in Album:: \"test_album\");",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.VerifiedPermissions.Policy("test", new()
 *     {
 *         PolicyStoreId = testAwsVerifiedpermissionsPolicyStore.Id,
 *         Definition = new Aws.VerifiedPermissions.Inputs.PolicyDefinitionArgs
 *         {
 *             Static = new Aws.VerifiedPermissions.Inputs.PolicyDefinitionStaticArgs
 *             {
 *                 Statement = "permit (principal, action == Action::\"view\", resource in Album:: \"test_album\");",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedpermissions.NewPolicy(ctx, "test", &verifiedpermissions.PolicyArgs{
 * 			PolicyStoreId: pulumi.Any(testAwsVerifiedpermissionsPolicyStore.Id),
 * 			Definition: &verifiedpermissions.PolicyDefinitionArgs{
 * 				Static: &verifiedpermissions.PolicyDefinitionStaticArgs{
 * 					Statement: pulumi.String("permit (principal, action == Action::\"view\", resource in Album:: \"test_album\");"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.Policy;
 * import com.pulumi.aws.verifiedpermissions.PolicyArgs;
 * import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionArgs;
 * import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionStaticArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Policy("test", PolicyArgs.builder()
 *             .policyStoreId(testAwsVerifiedpermissionsPolicyStore.id())
 *             .definition(PolicyDefinitionArgs.builder()
 *                 .static_(PolicyDefinitionStaticArgs.builder()
 *                     .statement("permit (principal, action == Action::\"view\", resource in Album:: \"test_album\");")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:verifiedpermissions:Policy
 *     properties:
 *       policyStoreId: ${testAwsVerifiedpermissionsPolicyStore.id}
 *       definition:
 *         static:
 *           statement: 'permit (principal, action == Action::"view", resource in Album:: "test_album");'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy using the `policy_id,policy_store_id`. For example:
 * ```sh
 * $ pulumi import aws:verifiedpermissions/policy:Policy example policy-id-12345678,policy-store-id-12345678
 * ```
 * @property definition The definition of the policy. See Definition below.
 * @property policyStoreId The Policy Store ID of the policy store.
 */
public data class PolicyArgs(
    public val definition: Output<PolicyDefinitionArgs>? = null,
    public val policyStoreId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.PolicyArgs =
        com.pulumi.aws.verifiedpermissions.PolicyArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyStoreId(policyStoreId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var definition: Output<PolicyDefinitionArgs>? = null

    private var policyStoreId: Output<String>? = null

    /**
     * @param value The definition of the policy. See Definition below.
     */
    @JvmName("spsmieracmlpcbtp")
    public suspend fun definition(`value`: Output<PolicyDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value The Policy Store ID of the policy store.
     */
    @JvmName("khmmoxangfctiumi")
    public suspend fun policyStoreId(`value`: Output<String>) {
        this.policyStoreId = value
    }

    /**
     * @param value The definition of the policy. See Definition below.
     */
    @JvmName("mqnmbsguiisrmgpw")
    public suspend fun definition(`value`: PolicyDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument The definition of the policy. See Definition below.
     */
    @JvmName("keirufsxjbkptwpl")
    public suspend fun definition(argument: suspend PolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value The Policy Store ID of the policy store.
     */
    @JvmName("roxymyuimtdbvhwj")
    public suspend fun policyStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyStoreId = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        definition = definition,
        policyStoreId = policyStoreId,
    )
}
