@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyStoreValidationSettings
import com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyStoreValidationSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyStore].
 */
@PulumiTagMarker
public class PolicyStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyStoreArgs = PolicyStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyStoreArgsBuilder.() -> Unit) {
        val builder = PolicyStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyStore {
        val builtJavaResource = com.pulumi.aws.verifiedpermissions.PolicyStore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyStore(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedpermissions.PolicyStore("example", {validationSettings: {
 *     mode: "STRICT",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
 *     "mode": "STRICT",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedPermissions.PolicyStore("example", new()
 *     {
 *         ValidationSettings = new Aws.VerifiedPermissions.Inputs.PolicyStoreValidationSettingsArgs
 *         {
 *             Mode = "STRICT",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedpermissions.NewPolicyStore(ctx, "example", &verifiedpermissions.PolicyStoreArgs{
 * 			ValidationSettings: &verifiedpermissions.PolicyStoreValidationSettingsArgs{
 * 				Mode: pulumi.String("STRICT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.PolicyStore;
 * import com.pulumi.aws.verifiedpermissions.PolicyStoreArgs;
 * import com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyStore("example", PolicyStoreArgs.builder()
 *             .validationSettings(PolicyStoreValidationSettingsArgs.builder()
 *                 .mode("STRICT")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:PolicyStore
 *     properties:
 *       validationSettings:
 *         mode: STRICT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id`. For example:
 * console
 *  % pulumi import aws_verifiedpermissions_policy_store.example DxQg2j8xvXJQ1tQCYNWj9T
 */
public class PolicyStore internal constructor(
    override val javaResource: com.pulumi.aws.verifiedpermissions.PolicyStore,
) : KotlinCustomResource(javaResource, PolicyStoreMapper) {
    /**
     * The ARN of the Policy Store.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the Policy Store.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Policy Store.
     */
    public val policyStoreId: Output<String>
        get() = javaResource.policyStoreId().applyValue({ args0 -> args0 })

    /**
     * Validation settings for the policy store.
     */
    public val validationSettings: Output<PolicyStoreValidationSettings>?
        get() = javaResource.validationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object PolicyStoreMapper : ResourceMapper<PolicyStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedpermissions.PolicyStore::class == javaResource::class

    override fun map(javaResource: Resource): PolicyStore = PolicyStore(
        javaResource as
            com.pulumi.aws.verifiedpermissions.PolicyStore,
    )
}

/**
 * @see [PolicyStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyStore].
 */
public suspend fun policyStore(name: String, block: suspend PolicyStoreResourceBuilder.() -> Unit): PolicyStore {
    val builder = PolicyStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyStore(name: String): PolicyStore {
    val builder = PolicyStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
