@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.PolicyStoreArgs.builder
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.PolicyStoreValidationSettingsArgs
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.PolicyStoreValidationSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedpermissions.PolicyStore("example", {validationSettings: {
 *     mode: "STRICT",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
 *     "mode": "STRICT",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedPermissions.PolicyStore("example", new()
 *     {
 *         ValidationSettings = new Aws.VerifiedPermissions.Inputs.PolicyStoreValidationSettingsArgs
 *         {
 *             Mode = "STRICT",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedpermissions.NewPolicyStore(ctx, "example", &verifiedpermissions.PolicyStoreArgs{
 * 			ValidationSettings: &verifiedpermissions.PolicyStoreValidationSettingsArgs{
 * 				Mode: pulumi.String("STRICT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.PolicyStore;
 * import com.pulumi.aws.verifiedpermissions.PolicyStoreArgs;
 * import com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyStore("example", PolicyStoreArgs.builder()
 *             .validationSettings(PolicyStoreValidationSettingsArgs.builder()
 *                 .mode("STRICT")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:PolicyStore
 *     properties:
 *       validationSettings:
 *         mode: STRICT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id`. For example:
 * console
 *  % pulumi import aws_verifiedpermissions_policy_store.example DxQg2j8xvXJQ1tQCYNWj9T
 * @property description A description of the Policy Store.
 * @property validationSettings Validation settings for the policy store.
 */
public data class PolicyStoreArgs(
    public val description: Output<String>? = null,
    public val validationSettings: Output<PolicyStoreValidationSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.PolicyStoreArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.PolicyStoreArgs =
        com.pulumi.aws.verifiedpermissions.PolicyStoreArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .validationSettings(
                validationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyStoreArgs].
 */
@PulumiTagMarker
public class PolicyStoreArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var validationSettings: Output<PolicyStoreValidationSettingsArgs>? = null

    /**
     * @param value A description of the Policy Store.
     */
    @JvmName("tdblgmsmqyryiidf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Validation settings for the policy store.
     */
    @JvmName("flcqskobhxjqosmi")
    public suspend fun validationSettings(`value`: Output<PolicyStoreValidationSettingsArgs>) {
        this.validationSettings = value
    }

    /**
     * @param value A description of the Policy Store.
     */
    @JvmName("cmhijcwdhgwkaisg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Validation settings for the policy store.
     */
    @JvmName("rntlygyfkxbseqew")
    public suspend fun validationSettings(`value`: PolicyStoreValidationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationSettings = mapped
    }

    /**
     * @param argument Validation settings for the policy store.
     */
    @JvmName("rrilhlvflyjrskqq")
    public suspend fun validationSettings(argument: suspend PolicyStoreValidationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyStoreValidationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationSettings = mapped
    }

    internal fun build(): PolicyStoreArgs = PolicyStoreArgs(
        description = description,
        validationSettings = validationSettings,
    )
}
