@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyTemplate].
 */
@PulumiTagMarker
public class PolicyTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyTemplateArgs = PolicyTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyTemplateArgsBuilder.() -> Unit) {
        val builder = PolicyTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyTemplate {
        val builtJavaResource =
            com.pulumi.aws.verifiedpermissions.PolicyTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyTemplate(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Verified Permissions Policy Template.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedpermissions.PolicyTemplate("example", {
 *     policyStoreId: exampleAwsVerifiedpermissionsPolicyStore.id,
 *     statement: "permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedpermissions.PolicyTemplate("example",
 *     policy_store_id=example_aws_verifiedpermissions_policy_store["id"],
 *     statement="permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedPermissions.PolicyTemplate("example", new()
 *     {
 *         PolicyStoreId = exampleAwsVerifiedpermissionsPolicyStore.Id,
 *         Statement = "permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedpermissions.NewPolicyTemplate(ctx, "example", &verifiedpermissions.PolicyTemplateArgs{
 * 			PolicyStoreId: pulumi.Any(exampleAwsVerifiedpermissionsPolicyStore.Id),
 * 			Statement:     pulumi.String("permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.PolicyTemplate;
 * import com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTemplate("example", PolicyTemplateArgs.builder()
 *             .policyStoreId(exampleAwsVerifiedpermissionsPolicyStore.id())
 *             .statement("permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:PolicyTemplate
 *     properties:
 *       policyStoreId: ${exampleAwsVerifiedpermissionsPolicyStore.id}
 *       statement: permit (principal in ?principal, action in PhotoFlash::Action::"FullPhotoAccess", resource == ?resource) unless { resource.IsPrivate };
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id:policy_template_id`. For example:
 * ```sh
 * $ pulumi import aws:verifiedpermissions/policyTemplate:PolicyTemplate example policyStoreId:policyTemplateId
 * ```
 */
public class PolicyTemplate internal constructor(
    override val javaResource: com.pulumi.aws.verifiedpermissions.PolicyTemplate,
) : KotlinCustomResource(javaResource, PolicyTemplateMapper) {
    /**
     * The date the Policy Store was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Provides a description for the policy template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Policy Store.
     */
    public val policyStoreId: Output<String>
        get() = javaResource.policyStoreId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Policy Store.
     */
    public val policyTemplateId: Output<String>
        get() = javaResource.policyTemplateId().applyValue({ args0 -> args0 })

    /**
     * Defines the content of the statement, written in Cedar policy language.
     * The following arguments are optional:
     */
    public val statement: Output<String>
        get() = javaResource.statement().applyValue({ args0 -> args0 })
}

public object PolicyTemplateMapper : ResourceMapper<PolicyTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedpermissions.PolicyTemplate::class == javaResource::class

    override fun map(javaResource: Resource): PolicyTemplate = PolicyTemplate(
        javaResource as
            com.pulumi.aws.verifiedpermissions.PolicyTemplate,
    )
}

/**
 * @see [PolicyTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyTemplate].
 */
public suspend fun policyTemplate(
    name: String,
    block: suspend PolicyTemplateResourceBuilder.() -> Unit,
): PolicyTemplate {
    val builder = PolicyTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyTemplate(name: String): PolicyTemplate {
    val builder = PolicyTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
