@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Verified Permissions Policy Template.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.verifiedpermissions.PolicyTemplate("example", {
 *     policyStoreId: exampleAwsVerifiedpermissionsPolicyStore.id,
 *     statement: "permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.verifiedpermissions.PolicyTemplate("example",
 *     policy_store_id=example_aws_verifiedpermissions_policy_store["id"],
 *     statement="permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VerifiedPermissions.PolicyTemplate("example", new()
 *     {
 *         PolicyStoreId = exampleAwsVerifiedpermissionsPolicyStore.Id,
 *         Statement = "permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := verifiedpermissions.NewPolicyTemplate(ctx, "example", &verifiedpermissions.PolicyTemplateArgs{
 * 			PolicyStoreId: pulumi.Any(exampleAwsVerifiedpermissionsPolicyStore.Id),
 * 			Statement:     pulumi.String("permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.PolicyTemplate;
 * import com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTemplate("example", PolicyTemplateArgs.builder()
 *             .policyStoreId(exampleAwsVerifiedpermissionsPolicyStore.id())
 *             .statement("permit (principal in ?principal, action in PhotoFlash::Action::\"FullPhotoAccess\", resource == ?resource) unless { resource.IsPrivate };")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:PolicyTemplate
 *     properties:
 *       policyStoreId: ${exampleAwsVerifiedpermissionsPolicyStore.id}
 *       statement: permit (principal in ?principal, action in PhotoFlash::Action::"FullPhotoAccess", resource == ?resource) unless { resource.IsPrivate };
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id:policy_template_id`. For example:
 * ```sh
 * $ pulumi import aws:verifiedpermissions/policyTemplate:PolicyTemplate example policyStoreId:policyTemplateId
 * ```
 * @property description Provides a description for the policy template.
 * @property policyStoreId The ID of the Policy Store.
 * @property statement Defines the content of the statement, written in Cedar policy language.
 * The following arguments are optional:
 */
public data class PolicyTemplateArgs(
    public val description: Output<String>? = null,
    public val policyStoreId: Output<String>? = null,
    public val statement: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs =
        com.pulumi.aws.verifiedpermissions.PolicyTemplateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .policyStoreId(policyStoreId?.applyValue({ args0 -> args0 }))
            .statement(statement?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTemplateArgs].
 */
@PulumiTagMarker
public class PolicyTemplateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var policyStoreId: Output<String>? = null

    private var statement: Output<String>? = null

    /**
     * @param value Provides a description for the policy template.
     */
    @JvmName("emdnmrrulagybqib")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Policy Store.
     */
    @JvmName("somqkmrdierqyxuu")
    public suspend fun policyStoreId(`value`: Output<String>) {
        this.policyStoreId = value
    }

    /**
     * @param value Defines the content of the statement, written in Cedar policy language.
     * The following arguments are optional:
     */
    @JvmName("kmvtukcjdbnrrnim")
    public suspend fun statement(`value`: Output<String>) {
        this.statement = value
    }

    /**
     * @param value Provides a description for the policy template.
     */
    @JvmName("xtwchmbxwbivprtr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Policy Store.
     */
    @JvmName("aiisdnvroyrtdfkb")
    public suspend fun policyStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyStoreId = mapped
    }

    /**
     * @param value Defines the content of the statement, written in Cedar policy language.
     * The following arguments are optional:
     */
    @JvmName("vvtogspwidboestp")
    public suspend fun statement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statement = mapped
    }

    internal fun build(): PolicyTemplateArgs = PolicyTemplateArgs(
        description = description,
        policyStoreId = policyStoreId,
        statement = statement,
    )
}
