@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.kotlin.outputs.SchemaDefinition
import com.pulumi.aws.verifiedpermissions.kotlin.outputs.SchemaDefinition.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Schema].
 */
@PulumiTagMarker
public class SchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchemaArgs = SchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchemaArgsBuilder.() -> Unit) {
        val builder = SchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schema {
        val builtJavaResource = com.pulumi.aws.verifiedpermissions.Schema(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schema(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.Schema;
 * import com.pulumi.aws.verifiedpermissions.SchemaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schema("example", SchemaArgs.builder()
 *             .policyStoreId(exampleAwsVerifiedpermissionsPolicyStore.policyStoreId())
 *             .definition(SchemaDefinitionArgs.builder()
 *                 .value(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Namespace", jsonObject(
 *                             jsonProperty("entityTypes", jsonObject(
 *                             )),
 *                             jsonProperty("actions", jsonObject(
 *                             ))
 *                         ))
 *                     )))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:Schema
 *     properties:
 *       policyStoreId: ${exampleAwsVerifiedpermissionsPolicyStore.policyStoreId}
 *       definition:
 *         - value:
 *             fn::toJSON:
 *               Namespace:
 *                 entityTypes: {}
 *                 actions: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store Schema using the `policy_store_id`. For example:
 * console
 *  % pulumi import aws_verifiedpermissions_schema.example DxQg2j8xvXJQ1tQCYNWj9T
 */
public class Schema internal constructor(
    override val javaResource: com.pulumi.aws.verifiedpermissions.Schema,
) : KotlinCustomResource(javaResource, SchemaMapper) {
    /**
     * The definition of the schema.
     */
    public val definition: Output<SchemaDefinition>?
        get() = javaResource.definition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * (Optional) Identifies the namespaces of the entities referenced by this schema.
     */
    public val namespaces: Output<List<String>>
        get() = javaResource.namespaces().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the Policy Store.
     */
    public val policyStoreId: Output<String>
        get() = javaResource.policyStoreId().applyValue({ args0 -> args0 })
}

public object SchemaMapper : ResourceMapper<Schema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedpermissions.Schema::class == javaResource::class

    override fun map(javaResource: Resource): Schema = Schema(
        javaResource as
            com.pulumi.aws.verifiedpermissions.Schema,
    )
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schema].
 */
public suspend fun schema(name: String, block: suspend SchemaResourceBuilder.() -> Unit): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schema(name: String): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
