@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.SchemaArgs.builder
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.SchemaDefinitionArgs
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.SchemaDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedpermissions.Schema;
 * import com.pulumi.aws.verifiedpermissions.SchemaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schema("example", SchemaArgs.builder()
 *             .policyStoreId(exampleAwsVerifiedpermissionsPolicyStore.policyStoreId())
 *             .definition(SchemaDefinitionArgs.builder()
 *                 .value(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Namespace", jsonObject(
 *                             jsonProperty("entityTypes", jsonObject(
 *                             )),
 *                             jsonProperty("actions", jsonObject(
 *                             ))
 *                         ))
 *                     )))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:verifiedpermissions:Schema
 *     properties:
 *       policyStoreId: ${exampleAwsVerifiedpermissionsPolicyStore.policyStoreId}
 *       definition:
 *         - value:
 *             fn::toJSON:
 *               Namespace:
 *                 entityTypes: {}
 *                 actions: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Verified Permissions Policy Store Schema using the `policy_store_id`. For example:
 * console
 *  % pulumi import aws_verifiedpermissions_schema.example DxQg2j8xvXJQ1tQCYNWj9T
 * @property definition The definition of the schema.
 * @property policyStoreId The ID of the Policy Store.
 */
public data class SchemaArgs(
    public val definition: Output<SchemaDefinitionArgs>? = null,
    public val policyStoreId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.SchemaArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.SchemaArgs =
        com.pulumi.aws.verifiedpermissions.SchemaArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyStoreId(policyStoreId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var definition: Output<SchemaDefinitionArgs>? = null

    private var policyStoreId: Output<String>? = null

    /**
     * @param value The definition of the schema.
     */
    @JvmName("efvvsrnjkebchqco")
    public suspend fun definition(`value`: Output<SchemaDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value The ID of the Policy Store.
     */
    @JvmName("wmpvyrilwxakurny")
    public suspend fun policyStoreId(`value`: Output<String>) {
        this.policyStoreId = value
    }

    /**
     * @param value The definition of the schema.
     */
    @JvmName("medvgtjkqlshtiot")
    public suspend fun definition(`value`: SchemaDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument The definition of the schema.
     */
    @JvmName("nrxkdokqyyvglbgs")
    public suspend fun definition(argument: suspend SchemaDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = SchemaDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value The ID of the Policy Store.
     */
    @JvmName("oplqrfbppghfpdqj")
    public suspend fun policyStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyStoreId = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        definition = definition,
        policyStoreId = policyStoreId,
    )
}
