@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin

import com.pulumi.aws.verifiedpermissions.VerifiedpermissionsFunctions.getPolicyStorePlain
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.GetPolicyStorePlainArgs
import com.pulumi.aws.verifiedpermissions.kotlin.inputs.GetPolicyStorePlainArgsBuilder
import com.pulumi.aws.verifiedpermissions.kotlin.outputs.GetPolicyStoreResult
import com.pulumi.aws.verifiedpermissions.kotlin.outputs.GetPolicyStoreResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object VerifiedpermissionsFunctions {
    /**
     * Data source for managing an AWS Verified Permissions Policy Store.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.verifiedpermissions.getPolicyStore({
     *     id: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.verifiedpermissions.get_policy_store(id="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.VerifiedPermissions.GetPolicyStore.Invoke(new()
     *     {
     *         Id = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/verifiedpermissions"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := verifiedpermissions.LookupPolicyStore(ctx, &verifiedpermissions.LookupPolicyStoreArgs{
     * 			Id: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.verifiedpermissions.VerifiedpermissionsFunctions;
     * import com.pulumi.aws.verifiedpermissions.inputs.GetPolicyStoreArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VerifiedpermissionsFunctions.getPolicyStore(GetPolicyStoreArgs.builder()
     *             .id("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:verifiedpermissions:getPolicyStore
     *       Arguments:
     *         id: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicyStore.
     * @return A collection of values returned by getPolicyStore.
     */
    public suspend fun getPolicyStore(argument: GetPolicyStorePlainArgs): GetPolicyStoreResult =
        toKotlin(getPolicyStorePlain(argument.toJava()).await())

    /**
     * @see [getPolicyStore].
     * @param id The ID of the Policy Store.
     * @return A collection of values returned by getPolicyStore.
     */
    public suspend fun getPolicyStore(id: String): GetPolicyStoreResult {
        val argument = GetPolicyStorePlainArgs(
            id = id,
        )
        return toKotlin(getPolicyStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyStore].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;verifiedpermissions&#46;kotlin&#46;inputs&#46;GetPolicyStorePlainArgs].
     * @return A collection of values returned by getPolicyStore.
     */
    public suspend fun getPolicyStore(argument: suspend GetPolicyStorePlainArgsBuilder.() -> Unit): GetPolicyStoreResult {
        val builder = GetPolicyStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getPolicyStorePlain(builtArgument.toJava()).await())
    }
}
