@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.GetPolicyStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicyStore.
 * @property id The ID of the Policy Store.
 */
public data class GetPolicyStorePlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.GetPolicyStorePlainArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.GetPolicyStorePlainArgs =
        com.pulumi.aws.verifiedpermissions.inputs.GetPolicyStorePlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyStorePlainArgs].
 */
@PulumiTagMarker
public class GetPolicyStorePlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value The ID of the Policy Store.
     */
    @JvmName("tcgcsflklouqoyls")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetPolicyStorePlainArgs = GetPolicyStorePlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
