@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cognitoUserPoolConfiguration Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
 * @property openIdConnectConfiguration Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
 */
public data class IdentitySourceConfigurationArgs(
    public val cognitoUserPoolConfiguration: Output<IdentitySourceConfigurationCognitoUserPoolConfigurationArgs>? = null,
    public val openIdConnectConfiguration: Output<IdentitySourceConfigurationOpenIdConnectConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationArgs.builder()
            .cognitoUserPoolConfiguration(
                cognitoUserPoolConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .openIdConnectConfiguration(
                openIdConnectConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentitySourceConfigurationArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationArgsBuilder internal constructor() {
    private var cognitoUserPoolConfiguration:
        Output<IdentitySourceConfigurationCognitoUserPoolConfigurationArgs>? = null

    private var openIdConnectConfiguration:
        Output<IdentitySourceConfigurationOpenIdConnectConfigurationArgs>? = null

    /**
     * @param value Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
     */
    @JvmName("owkhdefsdqoavdmn")
    public suspend fun cognitoUserPoolConfiguration(`value`: Output<IdentitySourceConfigurationCognitoUserPoolConfigurationArgs>) {
        this.cognitoUserPoolConfiguration = value
    }

    /**
     * @param value Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
     */
    @JvmName("hqheifhideirgmyv")
    public suspend fun openIdConnectConfiguration(`value`: Output<IdentitySourceConfigurationOpenIdConnectConfigurationArgs>) {
        this.openIdConnectConfiguration = value
    }

    /**
     * @param value Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
     */
    @JvmName("qbpqhdgknojpltmn")
    public suspend fun cognitoUserPoolConfiguration(`value`: IdentitySourceConfigurationCognitoUserPoolConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoUserPoolConfiguration = mapped
    }

    /**
     * @param argument Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
     */
    @JvmName("lgjncwgaintmxums")
    public suspend fun cognitoUserPoolConfiguration(argument: suspend IdentitySourceConfigurationCognitoUserPoolConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationCognitoUserPoolConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cognitoUserPoolConfiguration = mapped
    }

    /**
     * @param value Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
     */
    @JvmName("wghrvqqqmkeftxfa")
    public suspend fun openIdConnectConfiguration(`value`: IdentitySourceConfigurationOpenIdConnectConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openIdConnectConfiguration = mapped
    }

    /**
     * @param argument Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
     */
    @JvmName("auhcajslgtpmigwc")
    public suspend fun openIdConnectConfiguration(argument: suspend IdentitySourceConfigurationOpenIdConnectConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationOpenIdConnectConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.openIdConnectConfiguration = mapped
    }

    internal fun build(): IdentitySourceConfigurationArgs = IdentitySourceConfigurationArgs(
        cognitoUserPoolConfiguration = cognitoUserPoolConfiguration,
        openIdConnectConfiguration = openIdConnectConfiguration,
    )
}
