@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientIds The unique application client IDs that are associated with the specified Amazon Cognito user pool.
 * @property groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
 * @property userPoolArn The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
 */
public data class IdentitySourceConfigurationCognitoUserPoolConfigurationArgs(
    public val clientIds: Output<List<String>>? = null,
    public val groupConfiguration: Output<IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs>? = null,
    public val userPoolArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationArgs.builder()
            .clientIds(clientIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupConfiguration(
                groupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userPoolArn(userPoolArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceConfigurationCognitoUserPoolConfigurationArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationCognitoUserPoolConfigurationArgsBuilder internal constructor() {
    private var clientIds: Output<List<String>>? = null

    private var groupConfiguration:
        Output<IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs>? = null

    private var userPoolArn: Output<String>? = null

    /**
     * @param value The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     */
    @JvmName("hnvqbnjiupystonv")
    public suspend fun clientIds(`value`: Output<List<String>>) {
        this.clientIds = value
    }

    @JvmName("cecsiixwexwtqsir")
    public suspend fun clientIds(vararg values: Output<String>) {
        this.clientIds = Output.all(values.asList())
    }

    /**
     * @param values The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     */
    @JvmName("sqgrmmqhpuoikpkh")
    public suspend fun clientIds(values: List<Output<String>>) {
        this.clientIds = Output.all(values)
    }

    /**
     * @param value The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("uhiyjfcqnddeouvr")
    public suspend fun groupConfiguration(`value`: Output<IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs>) {
        this.groupConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
     */
    @JvmName("epcnpnqupkgjkkkb")
    public suspend fun userPoolArn(`value`: Output<String>) {
        this.userPoolArn = value
    }

    /**
     * @param value The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     */
    @JvmName("tmwywlgatubjeytu")
    public suspend fun clientIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param values The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     */
    @JvmName("rxbcnspsikqbqosq")
    public suspend fun clientIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param value The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("kbslwfbaulofhoip")
    public suspend fun groupConfiguration(`value`: IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupConfiguration = mapped
    }

    /**
     * @param argument The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("maixxjkppykeqyil")
    public suspend fun groupConfiguration(argument: suspend IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.groupConfiguration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
     */
    @JvmName("rmykgevyhfjrboib")
    public suspend fun userPoolArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolArn = mapped
    }

    internal fun build(): IdentitySourceConfigurationCognitoUserPoolConfigurationArgs =
        IdentitySourceConfigurationCognitoUserPoolConfigurationArgs(
            clientIds = clientIds,
            groupConfiguration = groupConfiguration,
            userPoolArn = userPoolArn ?: throw PulumiNullFieldException("userPoolArn"),
        )
}
