@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupEntityType The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
 */
public data class IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs(
    public val groupEntityType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs.builder()
            .groupEntityType(groupEntityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgsBuilder
internal constructor() {
    private var groupEntityType: Output<String>? = null

    /**
     * @param value The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
     */
    @JvmName("skafncxmioqhwwqb")
    public suspend fun groupEntityType(`value`: Output<String>) {
        this.groupEntityType = value
    }

    /**
     * @param value The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
     */
    @JvmName("ecmpamfogjjxacwq")
    public suspend fun groupEntityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupEntityType = mapped
    }

    internal fun build(): IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs =
        IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs(
            groupEntityType = groupEntityType ?: throw PulumiNullFieldException("groupEntityType"),
        )
}
