@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property entityIdPrefix A descriptive string that you want to prefix to user entities from your OIDC identity provider.
 * @property groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
 * @property issuer The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
 * @property tokenSelection The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfigurationArgs(
    public val entityIdPrefix: Output<String>? = null,
    public val groupConfiguration: Output<IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs>? = null,
    public val issuer: Output<String>,
    public val tokenSelection: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationArgs.builder()
            .entityIdPrefix(entityIdPrefix?.applyValue({ args0 -> args0 }))
            .groupConfiguration(
                groupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .issuer(issuer.applyValue({ args0 -> args0 }))
            .tokenSelection(
                tokenSelection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentitySourceConfigurationOpenIdConnectConfigurationArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationOpenIdConnectConfigurationArgsBuilder internal constructor() {
    private var entityIdPrefix: Output<String>? = null

    private var groupConfiguration:
        Output<IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs>? = null

    private var issuer: Output<String>? = null

    private var tokenSelection:
        Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs>? = null

    /**
     * @param value A descriptive string that you want to prefix to user entities from your OIDC identity provider.
     */
    @JvmName("nicwjfecuamboakr")
    public suspend fun entityIdPrefix(`value`: Output<String>) {
        this.entityIdPrefix = value
    }

    /**
     * @param value The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("rnxluhovjvfgitum")
    public suspend fun groupConfiguration(`value`: Output<IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs>) {
        this.groupConfiguration = value
    }

    /**
     * @param value The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
     */
    @JvmName("cnsihcufluguvtxk")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
     */
    @JvmName("wlsrywpsoeuxbldf")
    public suspend fun tokenSelection(`value`: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs>) {
        this.tokenSelection = value
    }

    /**
     * @param value A descriptive string that you want to prefix to user entities from your OIDC identity provider.
     */
    @JvmName("niimalpbjuesqljt")
    public suspend fun entityIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityIdPrefix = mapped
    }

    /**
     * @param value The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("tqghbgaitoxannol")
    public suspend fun groupConfiguration(`value`: IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupConfiguration = mapped
    }

    /**
     * @param argument The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
     */
    @JvmName("sijbqlpjvmodjbol")
    public suspend fun groupConfiguration(argument: suspend IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.groupConfiguration = mapped
    }

    /**
     * @param value The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
     */
    @JvmName("gbejjvmxlkvvqamv")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
     */
    @JvmName("mmokqvtrcbeywkjx")
    public suspend fun tokenSelection(`value`: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenSelection = mapped
    }

    /**
     * @param argument The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
     */
    @JvmName("soyswguijusojpdl")
    public suspend fun tokenSelection(argument: suspend IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tokenSelection = mapped
    }

    internal fun build(): IdentitySourceConfigurationOpenIdConnectConfigurationArgs =
        IdentitySourceConfigurationOpenIdConnectConfigurationArgs(
            entityIdPrefix = entityIdPrefix,
            groupConfiguration = groupConfiguration,
            issuer = issuer ?: throw PulumiNullFieldException("issuer"),
            tokenSelection = tokenSelection,
        )
}
