@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupClaim The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
 * @property groupEntityType The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs(
    public val groupClaim: Output<String>,
    public val groupEntityType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs.builder()
            .groupClaim(groupClaim.applyValue({ args0 -> args0 }))
            .groupEntityType(groupEntityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgsBuilder
internal constructor() {
    private var groupClaim: Output<String>? = null

    private var groupEntityType: Output<String>? = null

    /**
     * @param value The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
     */
    @JvmName("ccuduesdvyanuwkd")
    public suspend fun groupClaim(`value`: Output<String>) {
        this.groupClaim = value
    }

    /**
     * @param value The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
     */
    @JvmName("qmnysqxloixmrmqf")
    public suspend fun groupEntityType(`value`: Output<String>) {
        this.groupEntityType = value
    }

    /**
     * @param value The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
     */
    @JvmName("fqeiwnssrontwnwo")
    public suspend fun groupClaim(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupClaim = mapped
    }

    /**
     * @param value The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
     */
    @JvmName("lrxttigaedmttsim")
    public suspend fun groupEntityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupEntityType = mapped
    }

    internal fun build(): IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs = IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs(
        groupClaim = groupClaim ?: throw PulumiNullFieldException("groupClaim"),
        groupEntityType = groupEntityType ?: throw PulumiNullFieldException("groupEntityType"),
    )
}
