@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audiences The access token aud claim values that you want to accept in your policy store.
 * @property principalIdClaim The claim that determines the principal in OIDC access tokens.
 */
public data class
IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs(
    public val audiences: Output<List<String>>? = null,
    public val principalIdClaim: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs.builder()
            .audiences(audiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principalIdClaim(principalIdClaim?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs].
 */
@PulumiTagMarker
public class
IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgsBuilder
internal constructor() {
    private var audiences: Output<List<String>>? = null

    private var principalIdClaim: Output<String>? = null

    /**
     * @param value The access token aud claim values that you want to accept in your policy store.
     */
    @JvmName("gcmpeovcpayieblq")
    public suspend fun audiences(`value`: Output<List<String>>) {
        this.audiences = value
    }

    @JvmName("sbtqivyokrmoigrs")
    public suspend fun audiences(vararg values: Output<String>) {
        this.audiences = Output.all(values.asList())
    }

    /**
     * @param values The access token aud claim values that you want to accept in your policy store.
     */
    @JvmName("pjphxcvwsajqejik")
    public suspend fun audiences(values: List<Output<String>>) {
        this.audiences = Output.all(values)
    }

    /**
     * @param value The claim that determines the principal in OIDC access tokens.
     */
    @JvmName("pegyjpgnmcwxmtfp")
    public suspend fun principalIdClaim(`value`: Output<String>) {
        this.principalIdClaim = value
    }

    /**
     * @param value The access token aud claim values that you want to accept in your policy store.
     */
    @JvmName("gdbqyhwwvjflhvmi")
    public suspend fun audiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param values The access token aud claim values that you want to accept in your policy store.
     */
    @JvmName("hnoscxpysasycaiv")
    public suspend fun audiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param value The claim that determines the principal in OIDC access tokens.
     */
    @JvmName("albditofoquhpkqm")
    public suspend fun principalIdClaim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIdClaim = mapped
    }

    internal fun build(): IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs =
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs(
            audiences = audiences,
            principalIdClaim = principalIdClaim,
        )
}
