@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessTokenOnly The OIDC configuration for processing access tokens. See Access Token Only below.
 * @property identityTokenOnly The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs(
    public val accessTokenOnly: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs>? =
        null,
    public val identityTokenOnly: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs.builder()
            .accessTokenOnly(accessTokenOnly?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityTokenOnly(
                identityTokenOnly?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs].
 */
@PulumiTagMarker
public class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgsBuilder internal constructor() {
    private var accessTokenOnly:
        Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs>? =
        null

    private var identityTokenOnly:
        Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs>? =
        null

    /**
     * @param value The OIDC configuration for processing access tokens. See Access Token Only below.
     */
    @JvmName("jjkwayndoducdfhm")
    public suspend fun accessTokenOnly(`value`: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs>) {
        this.accessTokenOnly = value
    }

    /**
     * @param value The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
     */
    @JvmName("klxnxcyjqgyqhsvl")
    public suspend fun identityTokenOnly(`value`: Output<IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs>) {
        this.identityTokenOnly = value
    }

    /**
     * @param value The OIDC configuration for processing access tokens. See Access Token Only below.
     */
    @JvmName("hygcwadkvfuxutbb")
    public suspend fun accessTokenOnly(`value`: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTokenOnly = mapped
    }

    /**
     * @param argument The OIDC configuration for processing access tokens. See Access Token Only below.
     */
    @JvmName("acmdqqjcilnbjjaq")
    public suspend fun accessTokenOnly(argument: suspend IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessTokenOnly = mapped
    }

    /**
     * @param value The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
     */
    @JvmName("pfslwaewvcljeevi")
    public suspend fun identityTokenOnly(`value`: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityTokenOnly = mapped
    }

    /**
     * @param argument The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
     */
    @JvmName("uuwhqkvfvatuqdci")
    public suspend fun identityTokenOnly(argument: suspend IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgsBuilder.() -> Unit) {
        val toBeMapped =
            IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.identityTokenOnly = mapped
    }

    internal fun build(): IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs =
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs(
            accessTokenOnly = accessTokenOnly,
            identityTokenOnly = identityTokenOnly,
        )
}
