@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientIds The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
 * @property principalIdClaim The claim that determines the principal in OIDC access tokens.
 */
public data class
IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs(
    public val clientIds: Output<List<String>>? = null,
    public val principalIdClaim: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs =
        com.pulumi.aws.verifiedpermissions.inputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs.builder()
            .clientIds(clientIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principalIdClaim(principalIdClaim?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs].
 */
@PulumiTagMarker
public class
IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgsBuilder
internal constructor() {
    private var clientIds: Output<List<String>>? = null

    private var principalIdClaim: Output<String>? = null

    /**
     * @param value The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
     */
    @JvmName("rakivdbxsnbnmfek")
    public suspend fun clientIds(`value`: Output<List<String>>) {
        this.clientIds = value
    }

    @JvmName("gctdesvrwkpubswk")
    public suspend fun clientIds(vararg values: Output<String>) {
        this.clientIds = Output.all(values.asList())
    }

    /**
     * @param values The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
     */
    @JvmName("ylolutyaskwhvpww")
    public suspend fun clientIds(values: List<Output<String>>) {
        this.clientIds = Output.all(values)
    }

    /**
     * @param value The claim that determines the principal in OIDC access tokens.
     */
    @JvmName("pjmpfqhftrrrgjld")
    public suspend fun principalIdClaim(`value`: Output<String>) {
        this.principalIdClaim = value
    }

    /**
     * @param value The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
     */
    @JvmName("pbnigcgpajdkraqt")
    public suspend fun clientIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param values The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
     */
    @JvmName("dwwdqvbgudhdkafl")
    public suspend fun clientIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param value The claim that determines the principal in OIDC access tokens.
     */
    @JvmName("cnhxblygvrjivmqk")
    public suspend fun principalIdClaim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIdClaim = mapped
    }

    internal fun build(): IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs =
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs(
            clientIds = clientIds,
            principalIdClaim = principalIdClaim,
        )
}
