@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property static The static policy statement. See Static below.
 * @property templateLinked The template linked policy. See Template Linked below.
 */
public data class PolicyDefinitionArgs(
    public val static: Output<PolicyDefinitionStaticArgs>? = null,
    public val templateLinked: Output<PolicyDefinitionTemplateLinkedArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionArgs =
        com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionArgs.builder()
            .static_(static?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .templateLinked(
                templateLinked?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyDefinitionArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionArgsBuilder internal constructor() {
    private var static: Output<PolicyDefinitionStaticArgs>? = null

    private var templateLinked: Output<PolicyDefinitionTemplateLinkedArgs>? = null

    /**
     * @param value The static policy statement. See Static below.
     */
    @JvmName("iejeqdqdbbfgpith")
    public suspend fun static(`value`: Output<PolicyDefinitionStaticArgs>) {
        this.static = value
    }

    /**
     * @param value The template linked policy. See Template Linked below.
     */
    @JvmName("mtexguciabtbfyno")
    public suspend fun templateLinked(`value`: Output<PolicyDefinitionTemplateLinkedArgs>) {
        this.templateLinked = value
    }

    /**
     * @param value The static policy statement. See Static below.
     */
    @JvmName("juaccwgqxqjrrjmk")
    public suspend fun static(`value`: PolicyDefinitionStaticArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.static = mapped
    }

    /**
     * @param argument The static policy statement. See Static below.
     */
    @JvmName("ajrbehdirtfsvcnj")
    public suspend fun static(argument: suspend PolicyDefinitionStaticArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyDefinitionStaticArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.static = mapped
    }

    /**
     * @param value The template linked policy. See Template Linked below.
     */
    @JvmName("vtqpqihjmeajyeha")
    public suspend fun templateLinked(`value`: PolicyDefinitionTemplateLinkedArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateLinked = mapped
    }

    /**
     * @param argument The template linked policy. See Template Linked below.
     */
    @JvmName("ggkyeapstdcsenqu")
    public suspend fun templateLinked(argument: suspend PolicyDefinitionTemplateLinkedArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyDefinitionTemplateLinkedArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateLinked = mapped
    }

    internal fun build(): PolicyDefinitionArgs = PolicyDefinitionArgs(
        static = static,
        templateLinked = templateLinked,
    )
}
