@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionStaticArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the static policy.
 * @property statement The statement of the static policy.
 */
public data class PolicyDefinitionStaticArgs(
    public val description: Output<String>? = null,
    public val statement: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionStaticArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionStaticArgs =
        com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionStaticArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .statement(statement.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyDefinitionStaticArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionStaticArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var statement: Output<String>? = null

    /**
     * @param value The description of the static policy.
     */
    @JvmName("esxlakvxyjwsfudk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The statement of the static policy.
     */
    @JvmName("hhqdorvpdgemhohc")
    public suspend fun statement(`value`: Output<String>) {
        this.statement = value
    }

    /**
     * @param value The description of the static policy.
     */
    @JvmName("hfxmruntgegyayce")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The statement of the static policy.
     */
    @JvmName("enfswnfvrsienktg")
    public suspend fun statement(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statement = mapped
    }

    internal fun build(): PolicyDefinitionStaticArgs = PolicyDefinitionStaticArgs(
        description = description,
        statement = statement ?: throw PulumiNullFieldException("statement"),
    )
}
