@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property policyTemplateId The ID of the template.
 * @property principal The principal of the template linked policy.
 * @property resource The resource of the template linked policy.
 */
public data class PolicyDefinitionTemplateLinkedArgs(
    public val policyTemplateId: Output<String>,
    public val principal: Output<PolicyDefinitionTemplateLinkedPrincipalArgs>? = null,
    public val resource: Output<PolicyDefinitionTemplateLinkedResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedArgs =
        com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedArgs.builder()
            .policyTemplateId(policyTemplateId.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PolicyDefinitionTemplateLinkedArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionTemplateLinkedArgsBuilder internal constructor() {
    private var policyTemplateId: Output<String>? = null

    private var principal: Output<PolicyDefinitionTemplateLinkedPrincipalArgs>? = null

    private var resource: Output<PolicyDefinitionTemplateLinkedResourceArgs>? = null

    /**
     * @param value The ID of the template.
     */
    @JvmName("cphsivgaooepqpka")
    public suspend fun policyTemplateId(`value`: Output<String>) {
        this.policyTemplateId = value
    }

    /**
     * @param value The principal of the template linked policy.
     */
    @JvmName("jkgbghcquwrubfqq")
    public suspend fun principal(`value`: Output<PolicyDefinitionTemplateLinkedPrincipalArgs>) {
        this.principal = value
    }

    /**
     * @param value The resource of the template linked policy.
     */
    @JvmName("egjjohfvdoinutqd")
    public suspend fun resource(`value`: Output<PolicyDefinitionTemplateLinkedResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The ID of the template.
     */
    @JvmName("jjtocrodrfvwxibl")
    public suspend fun policyTemplateId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyTemplateId = mapped
    }

    /**
     * @param value The principal of the template linked policy.
     */
    @JvmName("angnbsykilluvbsv")
    public suspend fun principal(`value`: PolicyDefinitionTemplateLinkedPrincipalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param argument The principal of the template linked policy.
     */
    @JvmName("givdaaqedbstldxa")
    public suspend fun principal(argument: suspend PolicyDefinitionTemplateLinkedPrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyDefinitionTemplateLinkedPrincipalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.principal = mapped
    }

    /**
     * @param value The resource of the template linked policy.
     */
    @JvmName("jomugnybgshnuqxj")
    public suspend fun resource(`value`: PolicyDefinitionTemplateLinkedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The resource of the template linked policy.
     */
    @JvmName("jipcfoqvasvrejxu")
    public suspend fun resource(argument: suspend PolicyDefinitionTemplateLinkedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyDefinitionTemplateLinkedResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    internal fun build(): PolicyDefinitionTemplateLinkedArgs = PolicyDefinitionTemplateLinkedArgs(
        policyTemplateId = policyTemplateId ?: throw PulumiNullFieldException("policyTemplateId"),
        principal = principal,
        resource = resource,
    )
}
