@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityId The entity ID of the resource.
 * @property entityType The entity type of the resource.
 */
public data class PolicyDefinitionTemplateLinkedResourceArgs(
    public val entityId: Output<String>,
    public val entityType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedResourceArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedResourceArgs =
        com.pulumi.aws.verifiedpermissions.inputs.PolicyDefinitionTemplateLinkedResourceArgs.builder()
            .entityId(entityId.applyValue({ args0 -> args0 }))
            .entityType(entityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyDefinitionTemplateLinkedResourceArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionTemplateLinkedResourceArgsBuilder internal constructor() {
    private var entityId: Output<String>? = null

    private var entityType: Output<String>? = null

    /**
     * @param value The entity ID of the resource.
     */
    @JvmName("liqbwhadjuuesymn")
    public suspend fun entityId(`value`: Output<String>) {
        this.entityId = value
    }

    /**
     * @param value The entity type of the resource.
     */
    @JvmName("pnisqxmvyitkotdn")
    public suspend fun entityType(`value`: Output<String>) {
        this.entityType = value
    }

    /**
     * @param value The entity ID of the resource.
     */
    @JvmName("uagexomeuoiwpcbx")
    public suspend fun entityId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityId = mapped
    }

    /**
     * @param value The entity type of the resource.
     */
    @JvmName("faugrlbqbjadcdvj")
    public suspend fun entityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    internal fun build(): PolicyDefinitionTemplateLinkedResourceArgs =
        PolicyDefinitionTemplateLinkedResourceArgs(
            entityId = entityId ?: throw PulumiNullFieldException("entityId"),
            entityType = entityType ?: throw PulumiNullFieldException("entityType"),
        )
}
